/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.bundlor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.bundlor.BundledTypesRegistry;
import org.apache.jackrabbit.oak.plugins.document.bundlor.DocumentBundlor;
import org.apache.jackrabbit.oak.plugins.document.bundlor.Matcher;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class BundlingHandler {
    private final BundledTypesRegistry registry;
    private final String path;
    private final BundlingContext ctx;
    private final NodeState nodeState;

    public BundlingHandler(BundledTypesRegistry registry) {
        this((BundledTypesRegistry)Preconditions.checkNotNull((Object)registry), BundlingContext.NULL, "/", EmptyNodeState.EMPTY_NODE);
    }

    private BundlingHandler(BundledTypesRegistry registry, BundlingContext ctx, String path, NodeState nodeState) {
        this.registry = registry;
        this.path = path;
        this.ctx = ctx;
        this.nodeState = nodeState;
    }

    public String getPropertyPath(String propertyName) {
        return this.ctx.isBundling() ? this.ctx.getPropertyPath(propertyName) : propertyName;
    }

    public boolean isBundledNode() {
        return this.ctx.matcher.depth() > 0;
    }

    public String getNodeFullPath() {
        return this.path;
    }

    public NodeState getNodeState() {
        return this.nodeState;
    }

    public Set<PropertyState> getMetaProps() {
        return this.ctx.metaProps;
    }

    public Set<String> getRemovedProps() {
        return this.ctx.removedProps;
    }

    public String getRootBundlePath() {
        return this.ctx.isBundling() ? this.ctx.bundlingPath : this.path;
    }

    public BundlingHandler childAdded(String name, NodeState state) {
        BundlingContext childContext;
        String childPath = this.childPath(name);
        Matcher childMatcher = this.ctx.matcher.next(name);
        if (childMatcher.isMatch()) {
            childContext = this.createChildContext(childMatcher);
            childContext.addMetaProp(PropertyStates.createProperty((String)":doc-self-path", (Object)childMatcher.getMatchedPath()));
        } else {
            DocumentBundlor bundlor = this.registry.getBundlor(state);
            if (bundlor != null) {
                PropertyState bundlorConfig = bundlor.asPropertyState();
                childContext = new BundlingContext(childPath, bundlor.createMatcher());
                childContext.addMetaProp(bundlorConfig);
            } else {
                childContext = BundlingContext.NULL;
            }
        }
        return new BundlingHandler(this.registry, childContext, childPath, state);
    }

    public BundlingHandler childDeleted(String name, NodeState state) {
        BundlingContext childContext;
        String childPath = this.childPath(name);
        Matcher childMatcher = this.ctx.matcher.next(name);
        if (childMatcher.isMatch()) {
            childContext = this.createChildContext(childMatcher);
            BundlingHandler.removeDeletedChildProperties(state, childContext);
        } else {
            childContext = BundlingHandler.getBundlorContext(childPath, state);
            if (childContext.isBundling()) {
                BundlingHandler.removeBundlingMetaProps(state, childContext);
            }
        }
        return new BundlingHandler(this.registry, childContext, childPath, state);
    }

    public BundlingHandler childChanged(String name, NodeState before, NodeState after) {
        String childPath = this.childPath(name);
        Matcher childMatcher = this.ctx.matcher.next(name);
        BundlingContext childContext = childMatcher.isMatch() ? this.createChildContext(childMatcher) : BundlingHandler.getBundlorContext(childPath, before);
        return new BundlingHandler(this.registry, childContext, childPath, after);
    }

    public boolean isBundlingRoot() {
        if (this.ctx.isBundling()) {
            return this.ctx.bundlingPath.equals(this.path);
        }
        return true;
    }

    public String toString() {
        String result = this.path;
        if (this.isBundledNode()) {
            result = this.path + "( Bundling root - " + this.getRootBundlePath() + ")";
        }
        return result;
    }

    private String childPath(String name) {
        return PathUtils.concat((String)this.path, (String)name);
    }

    private BundlingContext createChildContext(Matcher childMatcher) {
        return this.ctx.child(childMatcher);
    }

    private static BundlingContext getBundlorContext(String path, NodeState state) {
        BundlingContext result = BundlingContext.NULL;
        PropertyState bundlorConfig = state.getProperty(":doc-pattern");
        if (bundlorConfig != null) {
            DocumentBundlor bundlor = DocumentBundlor.from(bundlorConfig);
            result = new BundlingContext(path, bundlor.createMatcher());
        }
        return result;
    }

    private static void removeDeletedChildProperties(NodeState state, BundlingContext childContext) {
        childContext.removeProperty(":doc-self-path");
        for (PropertyState ps : state.getProperties()) {
            String propName = ps.getName();
            if (propName.startsWith(":doc-has-child-")) continue;
            childContext.removeProperty(ps.getName());
        }
    }

    private static void removeBundlingMetaProps(NodeState state, BundlingContext childContext) {
        PropertyState bundlorConfig = state.getProperty(":doc-pattern");
        if (bundlorConfig != null) {
            childContext.removeProperty(":doc-pattern");
        }
    }

    private static class BundlingContext {
        static final BundlingContext NULL = new BundlingContext("", Matcher.NON_MATCHING);
        final String bundlingPath;
        final Matcher matcher;
        final Set<PropertyState> metaProps = Sets.newHashSet();
        final Set<String> removedProps = Sets.newHashSet();

        public BundlingContext(String bundlingPath, Matcher matcher) {
            this.bundlingPath = bundlingPath;
            this.matcher = matcher;
        }

        public BundlingContext child(Matcher matcher) {
            return new BundlingContext(this.bundlingPath, matcher);
        }

        public boolean isBundling() {
            return this.matcher.isMatch();
        }

        public String getPropertyPath(String propertyName) {
            return PathUtils.concat((String)this.matcher.getMatchedPath(), (String)propertyName);
        }

        public void addMetaProp(PropertyState state) {
            this.metaProps.add(state);
        }

        public void removeProperty(String name) {
            this.removedProps.add(name);
        }
    }
}

