/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheMap;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheMetadata;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.EvictionListener;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.KeyDataType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.MultiGenerationMap;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCacheStats;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.ValueDataType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheActionDispatcher;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheWriteQueue;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeCache<K, V>
implements Cache<K, V>,
PersistentCache.GenerationCache,
EvictionListener<K, V> {
    static final Logger LOG = LoggerFactory.getLogger(NodeCache.class);
    private static final Set<RemovalCause> EVICTION_CAUSES = ImmutableSet.of((Object)RemovalCause.COLLECTED, (Object)RemovalCause.EXPIRED, (Object)RemovalCause.SIZE);
    private final PersistentCache cache;
    private final PersistentCacheStats stats;
    private final Cache<K, V> memCache;
    private final MultiGenerationMap<K, V> map;
    private final CacheType type;
    private final DataType keyType;
    private final DataType valueType;
    private final CacheMetadata<K> memCacheMetadata;
    private final DocumentNodeStore nodeStore;
    private final boolean async;
    CacheWriteQueue<K, V> writeQueue;

    NodeCache(PersistentCache cache, Cache<K, V> memCache, DocumentNodeStore docNodeStore, DocumentStore docStore, CacheType type, CacheActionDispatcher dispatcher, StatisticsProvider statisticsProvider, boolean async) {
        this.cache = cache;
        this.memCache = memCache;
        this.type = type;
        this.nodeStore = docNodeStore;
        this.async = async;
        PersistentCache.LOG.info("wrapping map " + (Object)((Object)this.type));
        this.map = new MultiGenerationMap();
        this.keyType = new KeyDataType(type);
        this.valueType = new ValueDataType(docNodeStore, docStore, type);
        this.memCacheMetadata = new CacheMetadata();
        if (async) {
            this.writeQueue = new CacheWriteQueue<K, V>(dispatcher, cache, this.map);
            LOG.info("The persistent cache {} writes will be asynchronous", (Object)type);
        } else {
            this.writeQueue = null;
            this.memCacheMetadata.disable();
            LOG.info("The persistent cache {} writes will be synchronous", (Object)type);
        }
        this.stats = new PersistentCacheStats(type, statisticsProvider);
    }

    @Override
    public CacheType getType() {
        return this.type;
    }

    @Override
    public void addGeneration(int generation, boolean readOnly) {
        MVMap.Builder b = new MVMap.Builder().keyType(this.keyType).valueType(this.valueType);
        String mapName = this.type.name();
        CacheMap m = this.cache.openMap(generation, mapName, b);
        this.map.addReadMap(generation, m);
        if (!readOnly) {
            this.map.setWriteMap(m);
            this.stats.addWriteGeneration(generation);
        }
    }

    @Override
    public void removeGeneration(int generation) {
        this.map.removeReadMap(generation);
        this.stats.removeReadGeneration(generation);
    }

    private V readIfPresent(K key) {
        return this.async ? this.asyncReadIfPresent(key) : this.syncReadIfPresent(key);
    }

    private V syncReadIfPresent(K key) {
        this.cache.switchGenerationIfNeeded();
        TimerStats.Context ctx = this.stats.startReadTimer();
        V v = this.map.get(key);
        ctx.stop();
        if (v != null) {
            this.memCacheMetadata.putFromPersistenceAndIncrement(key);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V asyncReadIfPresent(K key) {
        TimerStats.Context ctx = this.stats.startReadTimer();
        try {
            MultiGenerationMap.ValueWithGenerationInfo<V> v = this.map.readValue(key);
            if (v == null) {
                V v2 = null;
                return v2;
            }
            if (v.isCurrentGeneration() && !this.cache.needSwitch()) {
                this.memCacheMetadata.putFromPersistenceAndIncrement(key);
            } else {
                this.memCacheMetadata.increment(key);
            }
            V v3 = v.getValue();
            return v3;
        }
        finally {
            ctx.stop();
        }
    }

    private void broadcast(final K key, final V value) {
        this.cache.broadcast(this.type, new Function<WriteBuffer, Void>(){

            @Nullable
            public Void apply(@Nullable WriteBuffer buffer) {
                NodeCache.this.keyType.write(buffer, key);
                if (value == null) {
                    buffer.put((byte)0);
                } else {
                    buffer.put((byte)1);
                    NodeCache.this.valueType.write(buffer, value);
                }
                return null;
            }
        });
    }

    private void write(K key, V value) {
        this.cache.switchGenerationIfNeeded();
        if (value == null) {
            this.map.remove(key);
        } else {
            if (!this.type.shouldCache(this.nodeStore, key)) {
                return;
            }
            this.map.put(key, value);
            long memory = 0L;
            memory += key == null ? 0L : (long)this.keyType.getMemory(key);
            this.stats.markBytesWritten(memory += value == null ? 0L : (long)this.valueType.getMemory(value));
            this.stats.markPut();
        }
    }

    @Nullable
    public V getIfPresent(Object key) {
        this.memCacheMetadata.increment(key);
        Object value = this.memCache.getIfPresent(key);
        if (value != null) {
            return (V)value;
        }
        this.memCacheMetadata.remove(key);
        this.stats.markRequest();
        value = this.readIfPresent(key);
        if (value != null) {
            this.memCache.put(key, value);
            this.stats.markHit();
        }
        return (V)value;
    }

    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        Object value = this.getIfPresent(key);
        if (value != null) {
            return value;
        }
        TimerStats.Context ctx = this.stats.startLoaderTimer();
        try {
            this.memCacheMetadata.increment(key);
            value = this.memCache.get(key, valueLoader);
            ctx.stop();
            if (!this.async) {
                this.write(key, value);
            }
            this.broadcast(key, value);
            return value;
        }
        catch (ExecutionException e) {
            this.stats.markException();
            throw e;
        }
    }

    public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
        Iterable<?> typedKeys = keys;
        this.memCacheMetadata.incrementAll(keys);
        ImmutableMap result = this.memCache.getAllPresent(keys);
        this.memCacheMetadata.removeAll(Iterables.filter(typedKeys, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)result.keySet()))));
        return result;
    }

    public void put(K key, V value) {
        this.memCacheMetadata.put(key);
        this.memCache.put(key, value);
        if (!this.async) {
            this.write(key, value);
        }
        this.broadcast(key, value);
    }

    public void invalidate(Object key) {
        this.memCache.invalidate(key);
        this.memCacheMetadata.remove(key);
        if (this.async) {
            this.writeQueue.addInvalidate(Collections.singleton(key));
        } else {
            this.write(key, null);
        }
        this.broadcast(key, null);
        this.stats.markInvalidateOne();
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.memCacheMetadata.putAll(m.keySet());
        this.memCache.putAll(m);
    }

    public void invalidateAll(Iterable<?> keys) {
        this.memCache.invalidateAll(keys);
        this.memCacheMetadata.removeAll(keys);
    }

    public void invalidateAll() {
        this.memCache.invalidateAll();
        this.memCacheMetadata.clear();
        this.map.clear();
        this.stats.markInvalidateAll();
    }

    public long size() {
        return this.memCache.size();
    }

    public CacheStats stats() {
        return this.memCache.stats();
    }

    public ConcurrentMap<K, V> asMap() {
        return this.memCache.asMap();
    }

    public void cleanUp() {
        this.memCache.cleanUp();
        this.memCacheMetadata.clear();
    }

    @Override
    public void receive(ByteBuffer buff) {
        Object value;
        Object key = this.keyType.read(buff);
        if (buff.get() == 0) {
            value = null;
            this.memCache.invalidate(key);
            this.memCacheMetadata.remove(key);
        } else {
            value = this.valueType.read(buff);
            this.memCacheMetadata.put(key);
            this.memCache.put(key, value);
        }
        this.stats.markRecvBroadcast();
        if (!this.async) {
            this.write(key, value);
        }
    }

    @Override
    public void evicted(K key, V value, RemovalCause cause) {
        if (this.async && EVICTION_CAUSES.contains(cause) && value != null) {
            CacheMetadata.MetadataEntry metadata = this.memCacheMetadata.remove(key);
            boolean qualifiesToPersist = true;
            if (metadata != null && metadata.isReadFromPersistentCache()) {
                qualifiesToPersist = false;
                this.stats.markPutRejectedAlreadyPersisted();
            } else if (metadata != null && metadata.getAccessCount() < 1L) {
                qualifiesToPersist = false;
                this.stats.markPutRejectedEntryNotUsed();
            } else if (!this.type.shouldCache(this.nodeStore, key)) {
                qualifiesToPersist = false;
                this.stats.markPutRejectedAsCachedInSecondary();
            }
            if (qualifiesToPersist) {
                boolean addedToQueue = this.writeQueue.addPut(key, value);
                if (addedToQueue) {
                    long memory = 0L;
                    memory += key == null ? 0L : (long)this.keyType.getMemory(key);
                    this.stats.markBytesWritten(memory += value == null ? 0L : (long)this.valueType.getMemory(value));
                    this.stats.markPut();
                } else {
                    this.stats.markPutRejectedQueueFull();
                }
            }
        }
    }

    public PersistentCacheStats getPersistentCacheStats() {
        return this.stats;
    }

    Map<K, V> getGenerationalMap() {
        return Collections.unmodifiableMap(this.map);
    }
}

