/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.collect.AbstractIterator;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.QueryBuilder;
import com.mongodb.ReadPreference;
import com.mongodb.WriteResult;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.blob.CachingBlobStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlob;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoBlobStore
extends CachingBlobStore {
    public static final String COLLECTION_BLOBS = "blobs";
    private static final Logger LOG = LoggerFactory.getLogger(MongoBlobStore.class);
    private final DB db;
    private long minLastModified;

    public MongoBlobStore(DB db) {
        this(db, 0x1000000L);
    }

    public MongoBlobStore(DB db, long cacheSize) {
        super(cacheSize);
        this.db = db;
        this.setBlockSize(2096128);
        this.initBlobCollection();
    }

    protected void storeBlock(byte[] digest, int level, byte[] data) throws IOException {
        String id = StringUtils.convertBytesToHex((byte[])digest);
        this.cache.put((Object)id, (Object)data);
        BasicDBObject mongoBlob = new BasicDBObject("_id", (Object)id);
        mongoBlob.append("data", (Object)data);
        mongoBlob.append("level", (Object)level);
        BasicDBObject updateBlob = new BasicDBObject("lastMod", (Object)System.currentTimeMillis());
        BasicDBObject upsert = new BasicDBObject();
        upsert.append("$setOnInsert", (Object)mongoBlob).append("$set", (Object)updateBlob);
        try {
            DBObject query = MongoBlobStore.getBlobQuery(id, -1L);
            WriteResult update = this.getBlobCollection().update(query, (DBObject)upsert, true, false);
            if (update != null && update.isUpdateOfExisting()) {
                LOG.trace("Block with id [{}] updated", (Object)id);
            } else {
                LOG.trace("Block with id [{}] created", (Object)id);
            }
        }
        catch (MongoException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId blockId) throws Exception {
        String id = StringUtils.convertBytesToHex((byte[])blockId.getDigest());
        byte[] data = (byte[])this.cache.get((Object)id);
        if (data == null) {
            long start = System.nanoTime();
            MongoBlob blobMongo = this.getBlob(id, 0L);
            if (blobMongo == null) {
                String message = "Did not find block " + id;
                LOG.error(message);
                throw new IOException(message);
            }
            data = blobMongo.getData();
            this.getStatsCollector().downloaded(id, System.nanoTime() - start, TimeUnit.NANOSECONDS, (long)data.length);
            this.cache.put((Object)id, (Object)data);
        }
        if (blockId.getPos() == 0L) {
            return data;
        }
        int len = (int)((long)data.length - blockId.getPos());
        if (len < 0) {
            return new byte[0];
        }
        byte[] d2 = new byte[len];
        System.arraycopy(data, (int)blockId.getPos(), d2, 0, len);
        return d2;
    }

    public void startMark() throws IOException {
        this.minLastModified = System.currentTimeMillis();
        this.markInUse();
    }

    protected boolean isMarkEnabled() {
        return this.minLastModified != 0L;
    }

    protected void mark(AbstractBlobStore.BlockId blockId) throws Exception {
        if (this.minLastModified == 0L) {
            return;
        }
        String id = StringUtils.convertBytesToHex((byte[])blockId.getDigest());
        DBObject query = MongoBlobStore.getBlobQuery(id, this.minLastModified);
        BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject("lastMod", (Object)System.currentTimeMillis()));
        this.getBlobCollection().update(query, (DBObject)update);
    }

    public int sweep() throws IOException {
        DBObject query = MongoBlobStore.getBlobQuery(null, this.minLastModified);
        long countBefore = this.getBlobCollection().count(query);
        this.getBlobCollection().remove(query);
        long countAfter = this.getBlobCollection().count(query);
        this.minLastModified = 0L;
        return (int)(countBefore - countAfter);
    }

    private DBCollection getBlobCollection() {
        DBCollection collection = this.db.getCollection(COLLECTION_BLOBS);
        collection.setObjectClass(MongoBlob.class);
        return collection;
    }

    private void initBlobCollection() {
        if (!this.db.collectionExists(COLLECTION_BLOBS)) {
            this.db.createCollection(COLLECTION_BLOBS, (DBObject)new BasicDBObject());
        }
    }

    private MongoBlob getBlob(String id, long lastMod) {
        DBObject query = MongoBlobStore.getBlobQuery(id, lastMod);
        ReadPreference pref = ReadPreference.secondaryPreferred();
        BasicDBObject fields = new BasicDBObject();
        fields.put("data", (Object)1);
        MongoBlob blob = (MongoBlob)this.getBlobCollection().findOne(query, (DBObject)fields, pref);
        if (blob == null) {
            pref = ReadPreference.primary();
            blob = (MongoBlob)this.getBlobCollection().findOne(query, (DBObject)fields, pref);
        }
        return blob;
    }

    private static DBObject getBlobQuery(String id, long lastMod) {
        QueryBuilder queryBuilder = new QueryBuilder();
        if (id != null) {
            queryBuilder = queryBuilder.and("_id").is((Object)id);
        }
        if (lastMod > 0L) {
            queryBuilder = queryBuilder.and("lastMod").lessThan((Object)lastMod);
        }
        return queryBuilder.get();
    }

    public long countDeleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        DBCollection collection = this.getBlobCollection();
        QueryBuilder queryBuilder = new QueryBuilder();
        if (chunkIds != null) {
            queryBuilder = queryBuilder.and("_id").in((Object)chunkIds.toArray(new String[0]));
            if (maxLastModifiedTime > 0L) {
                queryBuilder = queryBuilder.and("lastMod").lessThan((Object)maxLastModifiedTime);
            }
        }
        WriteResult result = collection.remove(queryBuilder.get());
        return result.getN();
    }

    public Iterator<String> getAllChunkIds(long maxLastModifiedTime) throws Exception {
        DBCollection collection = this.getBlobCollection();
        BasicDBObject fields = new BasicDBObject();
        fields.put("_id", (Object)1);
        QueryBuilder builder = new QueryBuilder();
        if (maxLastModifiedTime != 0L && maxLastModifiedTime != -1L) {
            builder.and("lastMod").lessThanEquals((Object)maxLastModifiedTime);
        }
        final DBCursor cur = collection.find(builder.get(), (DBObject)fields).hint((DBObject)fields).addOption(4);
        return new AbstractIterator<String>(){

            protected String computeNext() {
                MongoBlob blob;
                if (cur.hasNext() && (blob = (MongoBlob)cur.next()) != null) {
                    return blob.getId();
                }
                return (String)this.endOfData();
            }
        };
    }
}

