/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.io.Closeable;
import java.util.Iterator;
import org.apache.jackrabbit.oak.plugins.document.BlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;

public class MongoBlobReferenceIterator
extends BlobReferenceIterator {
    private final MongoDocumentStore documentStore;

    public MongoBlobReferenceIterator(DocumentNodeStore nodeStore, MongoDocumentStore documentStore) {
        super(nodeStore);
        this.documentStore = documentStore;
    }

    @Override
    public Iterator<NodeDocument> getIteratorOverDocsWithBinaries() {
        DBObject query = QueryBuilder.start((String)"_bin").is((Object)1L).get();
        DBCursor cursor = this.documentStore.getDBCollection(Collection.NODES).find(query).setReadPreference(this.documentStore.getConfiguredReadPreference(Collection.NODES));
        return CloseableIterable.wrap(Iterables.transform((Iterable)cursor, (Function)new Function<DBObject, NodeDocument>(){

            public NodeDocument apply(DBObject input) {
                return MongoBlobReferenceIterator.this.documentStore.convertFromDBObject(Collection.NODES, input);
            }
        }), (Closeable)cursor).iterator();
    }
}

