/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class PrefetchDispatcher
extends ChangeDispatcher {
    private final Executor executor;
    private NodeState root;

    public PrefetchDispatcher(@Nonnull NodeState root, @Nonnull Executor executor) {
        super(root);
        this.root = root;
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    public synchronized void contentChanged(@Nonnull NodeState root, @Nonnull CommitInfo info) {
        DocumentNodeState state;
        if (root instanceof DocumentNodeState && (state = (DocumentNodeState)root).isFromExternalChange()) {
            this.executor.execute(new Runnable(){
                private final NodeState before;
                {
                    this.before = PrefetchDispatcher.this.root;
                }

                @Override
                public void run() {
                    EditorDiff.process((Editor)new VisibleEditor(TraversingEditor.INSTANCE), (NodeState)this.before, (NodeState)state);
                }
            });
        }
        super.contentChanged(root, info);
        this.root = root;
    }

    private static final class TraversingEditor
    extends DefaultEditor {
        static final Editor INSTANCE = new TraversingEditor();

        private TraversingEditor() {
        }

        public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
            return this;
        }

        public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
            return this;
        }

        public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
            return this;
        }
    }
}

