/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.document.JournalEntry;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.spi.JournalProperty;
import org.apache.jackrabbit.oak.plugins.document.spi.JournalPropertyBuilder;
import org.apache.jackrabbit.oak.plugins.document.spi.JournalPropertyService;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.commit.CommitContext;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;

class JournalPropertyHandler {
    private final Map<String, JournalPropertyBuilder<JournalProperty>> builders = Maps.newHashMap();

    public JournalPropertyHandler(List<JournalPropertyService> services) {
        for (JournalPropertyService srv : services) {
            String name = srv.getName();
            if (!this.builders.containsKey(name)) {
                this.builders.put(name, srv.newBuilder());
                continue;
            }
            throw new IllegalStateException("Duplicate JournalPropertyService found for name - " + name + " Currently known services " + services);
        }
    }

    public void readFrom(CommitInfo info) {
        CommitContext commitContext = (CommitContext)info.getInfo().get("oak.commitAttributes");
        if (commitContext == null) {
            for (JournalPropertyBuilder<JournalProperty> builder : this.builders.values()) {
                builder.addProperty(null);
            }
            return;
        }
        for (Map.Entry<String, JournalPropertyBuilder<JournalProperty>> e : this.builders.entrySet()) {
            JournalPropertyBuilder<JournalProperty> builder = e.getValue();
            builder.addProperty(JournalPropertyHandler.getEntry(commitContext, e.getKey()));
        }
    }

    public void readFrom(JournalEntry entry) {
        for (Map.Entry<String, JournalPropertyBuilder<JournalProperty>> e : this.builders.entrySet()) {
            JournalPropertyBuilder<JournalProperty> builder = e.getValue();
            String name = Utils.escapePropertyName(e.getKey());
            builder.addSerializedProperty((String)entry.get(name));
        }
    }

    public void addTo(CommitContext commitContext) {
        for (Map.Entry<String, JournalPropertyBuilder<JournalProperty>> e : this.builders.entrySet()) {
            JournalPropertyBuilder<JournalProperty> builder = e.getValue();
            commitContext.set(e.getKey(), (Object)builder.build());
        }
    }

    public void addTo(UpdateOp op) {
        for (Map.Entry<String, JournalPropertyBuilder<JournalProperty>> e : this.builders.entrySet()) {
            JournalPropertyBuilder<JournalProperty> builder = e.getValue();
            String name = Utils.escapePropertyName(e.getKey());
            op.set(name, builder.buildAsString());
        }
    }

    private static JournalProperty getEntry(CommitContext cc, String name) {
        Object o = cc.get(name);
        if (o == null) {
            return null;
        }
        Preconditions.checkArgument((boolean)(o instanceof JournalProperty), (String)"CommitContext entry for name [%s] having value [%s] is not of type JournalEntry", (Object[])new Object[]{name, o});
        return (JournalProperty)o;
    }
}

