/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.broadcast.DynamicBroadcastConfig;

public class DocumentBroadcastConfig
implements DynamicBroadcastConfig {
    private final DocumentNodeStore documentNodeStore;

    public DocumentBroadcastConfig(DocumentNodeStore documentNodeStore) {
        this.documentNodeStore = documentNodeStore;
    }

    @Override
    public String getConfig() {
        return null;
    }

    @Override
    public List<Map<String, String>> getClientInfo() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (ClusterNodeInfoDocument doc : ClusterNodeInfoDocument.all(this.documentNodeStore.getDocumentStore())) {
            if (!doc.isActive()) continue;
            Object broadcastId = doc.get("broadcastId");
            Object listener = doc.get("broadcastListener");
            if (broadcastId == null || listener == null) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("broadcastId", broadcastId.toString());
            map.put("broadcastListener", listener.toString());
            list.add(map);
        }
        return list;
    }

    @Override
    public String connect(Map<String, String> clientInfo) {
        ClusterNodeInfo info = this.documentNodeStore.getClusterInfo();
        info.setInfo(clientInfo);
        return "" + info.getId();
    }

    @Override
    public void disconnect(String id) {
    }
}

