/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.FailedWithConflictException;
import org.apache.jackrabbit.oak.plugins.document.Revision;

class ConflictException
extends DocumentStoreException {
    private static final long serialVersionUID = 1418838561903727231L;
    private final Set<Revision> conflictRevisions;

    ConflictException(@Nonnull String message, @Nonnull Revision conflictRevision) {
        super((String)Preconditions.checkNotNull((Object)message));
        this.conflictRevisions = Collections.singleton(Preconditions.checkNotNull((Object)conflictRevision));
    }

    ConflictException(@Nonnull String message, @Nonnull Set<Revision> conflictRevisions) {
        super((String)Preconditions.checkNotNull((Object)message));
        this.conflictRevisions = (Set)Preconditions.checkNotNull(conflictRevisions);
    }

    ConflictException(@Nonnull String message) {
        super((String)Preconditions.checkNotNull((Object)message));
        this.conflictRevisions = Collections.emptySet();
    }

    CommitFailedException asCommitFailedException() {
        if (!this.conflictRevisions.isEmpty()) {
            return new FailedWithConflictException(this.conflictRevisions, this.getMessage(), this);
        }
        return new CommitFailedException("Merge", 1, "Failed to merge changes to the underlying store", (Throwable)this);
    }

    @Nonnull
    Iterable<Revision> getConflictRevisions() {
        return this.conflictRevisions;
    }
}

