/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.json.JsonSerializer;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.bundlor.BundlingHandler;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

class CommitDiff
implements NodeStateDiff {
    private final DocumentNodeStore store;
    private final Commit commit;
    private final JsopBuilder builder;
    private final BlobSerializer blobs;
    private final BundlingHandler bundlingHandler;

    CommitDiff(@Nonnull DocumentNodeStore store, @Nonnull Commit commit, @Nonnull BlobSerializer blobs) {
        this((DocumentNodeStore)Preconditions.checkNotNull((Object)store), (Commit)Preconditions.checkNotNull((Object)commit), store.getBundlingConfigHandler().newBundlingHandler(), new JsopBuilder(), (BlobSerializer)Preconditions.checkNotNull((Object)blobs));
    }

    private CommitDiff(DocumentNodeStore store, Commit commit, BundlingHandler bundlingHandler, JsopBuilder builder, BlobSerializer blobs) {
        this.store = store;
        this.commit = commit;
        this.bundlingHandler = bundlingHandler;
        this.builder = builder;
        this.blobs = blobs;
        this.performBundlingRelatedOperations();
    }

    public boolean propertyAdded(PropertyState after) {
        this.setProperty(after);
        return true;
    }

    public boolean propertyChanged(PropertyState before, PropertyState after) {
        this.setProperty(after);
        return true;
    }

    public boolean propertyDeleted(PropertyState before) {
        this.commit.updateProperty(this.bundlingHandler.getRootBundlePath(), this.bundlingHandler.getPropertyPath(before.getName()), null);
        return true;
    }

    public boolean childNodeAdded(String name, NodeState after) {
        BundlingHandler child = this.bundlingHandler.childAdded(name, after);
        if (child.isBundlingRoot()) {
            this.commit.addNode(new DocumentNodeState(this.store, child.getRootBundlePath(), new RevisionVector(this.commit.getRevision())));
        }
        this.setOrTouchChildrenFlag(child);
        return after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, (NodeStateDiff)new CommitDiff(this.store, this.commit, child, this.builder, this.blobs));
    }

    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        BundlingHandler child = this.bundlingHandler.childChanged(name, before, after);
        return after.compareAgainstBaseState(before, (NodeStateDiff)new CommitDiff(this.store, this.commit, child, this.builder, this.blobs));
    }

    public boolean childNodeDeleted(String name, NodeState before) {
        BundlingHandler child = this.bundlingHandler.childDeleted(name, before);
        if (child.isBundlingRoot()) {
            this.commit.removeNode(child.getRootBundlePath(), before);
        }
        this.setOrTouchChildrenFlag(child);
        return EmptyNodeState.MISSING_NODE.compareAgainstBaseState(before, (NodeStateDiff)new CommitDiff(this.store, this.commit, child, this.builder, this.blobs));
    }

    private void performBundlingRelatedOperations() {
        this.setMetaProperties();
        this.informCommitAboutBundledNodes();
        this.removeRemovedProps();
    }

    private void setMetaProperties() {
        for (PropertyState ps : this.bundlingHandler.getMetaProps()) {
            this.setProperty(ps);
        }
    }

    private void informCommitAboutBundledNodes() {
        if (this.bundlingHandler.isBundledNode()) {
            this.commit.addBundledNode(this.bundlingHandler.getNodeFullPath(), this.bundlingHandler.getRootBundlePath());
        }
    }

    private void removeRemovedProps() {
        for (String propName : this.bundlingHandler.getRemovedProps()) {
            this.commit.updateProperty(this.bundlingHandler.getRootBundlePath(), this.bundlingHandler.getPropertyPath(propName), null);
        }
    }

    private void setOrTouchChildrenFlag(BundlingHandler child) {
        String propName = null;
        if (child.isBundledNode()) {
            propName = ":doc-has-child-bundled";
        } else if (this.bundlingHandler.isBundledNode()) {
            propName = ":doc-has-child-non-bundled";
        }
        if (propName != null) {
            this.setProperty(PropertyStates.createProperty((String)propName, (Object)Boolean.TRUE));
        }
    }

    private void setProperty(PropertyState property) {
        this.builder.resetWriter();
        JsonSerializer serializer = new JsonSerializer((JsopWriter)this.builder, this.blobs);
        serializer.serialize(property);
        this.commit.updateProperty(this.bundlingHandler.getRootBundlePath(), this.bundlingHandler.getPropertyPath(property.getName()), serializer.toString());
        if (property.getType() == Type.BINARY || property.getType() == Type.BINARIES) {
            this.commit.markNodeHavingBinary(this.bundlingHandler.getRootBundlePath());
        }
    }
}

