/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Preconditions;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.bson.BSONObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RevisionEntry
implements DBObject {
    private final Revision revision;
    private final Object value;

    public RevisionEntry(@NotNull Revision revision, @Nullable Object value) {
        this.revision = (Revision)Preconditions.checkNotNull((Object)revision);
        this.value = value;
    }

    public void markAsPartialObject() {
    }

    public boolean isPartialObject() {
        return false;
    }

    public Object put(String key, Object v) {
        throw new UnsupportedOperationException();
    }

    public void putAll(BSONObject o) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    public Object get(String key) {
        return this.revision.toString().equals(key) ? this.value : null;
    }

    public Map toMap() {
        return Collections.singletonMap(this.revision.toString(), this.value);
    }

    public Object removeField(String key) {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(String s) {
        return this.containsField(s);
    }

    public boolean containsField(String s) {
        return this.revision.toString().equals(s);
    }

    public Set<String> keySet() {
        return Collections.singleton(this.revision.toString());
    }

    public String toString() {
        return new BasicDBObject(this.revision.toString(), this.value).toJson();
    }
}

