/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Preconditions;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.ReadConcernLevel;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.event.ServerMonitorListener;
import org.apache.jackrabbit.oak.plugins.document.mongo.CompositeServerMonitorListener;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoClock;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoSessionFactory;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoStatus;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoDBConnection {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBConnection.class);
    private final MongoClient client;
    private final MongoDatabase db;
    private final MongoStatus status;
    private final MongoClock clock;
    private final MongoSessionFactory sessionFactory;

    MongoDBConnection(@NotNull MongoClient client, @NotNull MongoDatabase database, @NotNull MongoStatus status, @NotNull MongoClock clock) {
        this.client = (MongoClient)Preconditions.checkNotNull((Object)client);
        this.db = (MongoDatabase)Preconditions.checkNotNull((Object)database);
        this.status = (MongoStatus)Preconditions.checkNotNull((Object)status);
        this.clock = (MongoClock)Preconditions.checkNotNull((Object)clock);
        this.sessionFactory = new MongoSessionFactory(client, clock);
    }

    static MongoDBConnection newMongoDBConnection(@NotNull String uri, @NotNull String name, @NotNull MongoClock clock, int socketTimeout, boolean socketKeepAlive) {
        CompositeServerMonitorListener serverMonitorListener = new CompositeServerMonitorListener();
        MongoClientOptions.Builder options = MongoConnection.getDefaultBuilder();
        options.addServerMonitorListener((ServerMonitorListener)serverMonitorListener);
        options.socketKeepAlive(socketKeepAlive);
        if (socketTimeout > 0) {
            options.socketTimeout(socketTimeout);
        }
        MongoClient client = new MongoClient(new MongoClientURI(uri, options));
        MongoStatus status = new MongoStatus(client, name);
        serverMonitorListener.addListener(status);
        MongoDatabase db = client.getDatabase(name);
        if (!MongoConnection.hasWriteConcern(uri)) {
            db = db.withWriteConcern(MongoConnection.getDefaultWriteConcern(client));
        }
        if (status.isMajorityReadConcernSupported() && status.isMajorityReadConcernEnabled() && !MongoConnection.hasReadConcern(uri)) {
            db = db.withReadConcern(MongoConnection.getDefaultReadConcern(client, db));
        }
        return new MongoDBConnection(client, db, status, clock);
    }

    @NotNull
    MongoClient getClient() {
        return this.client;
    }

    @NotNull
    MongoDatabase getDatabase() {
        return this.db;
    }

    @NotNull
    MongoStatus getStatus() {
        return this.status;
    }

    @NotNull
    MongoClock getClock() {
        return this.clock;
    }

    @NotNull
    MongoCollection<BasicDBObject> getCollection(@NotNull String name) {
        return this.db.getCollection(name, BasicDBObject.class);
    }

    @NotNull
    ClientSession createClientSession() {
        return this.sessionFactory.createClientSession();
    }

    void close() {
        this.client.close();
    }

    void checkReadWriteConcern() {
        if (!MongoConnection.isSufficientWriteConcern(this.client, this.db.getWriteConcern())) {
            LOG.warn("Insufficient write concern: {} At least {} is recommended.", (Object)this.db.getWriteConcern(), (Object)MongoConnection.getDefaultWriteConcern(this.client));
        }
        if (this.status.isMajorityReadConcernSupported() && !this.status.isMajorityReadConcernEnabled()) {
            LOG.warn("The read concern should be enabled on mongod using --enableMajorityReadConcern");
        } else if (this.status.isMajorityReadConcernSupported() && !MongoConnection.isSufficientReadConcern(this.client, this.db.getReadConcern())) {
            ReadConcernLevel currentLevel = MongoConnection.readConcernLevel(this.db.getReadConcern());
            ReadConcernLevel recommendedLevel = MongoConnection.readConcernLevel(MongoConnection.getDefaultReadConcern(this.client, this.db));
            if (currentLevel == null) {
                LOG.warn("Read concern hasn't been set. At least {} is recommended.", (Object)recommendedLevel);
            } else {
                LOG.warn("Insufficient read concern: {}}. At least {} is recommended.", (Object)currentLevel, (Object)recommendedLevel);
            }
        }
    }
}

