/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Objects;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.document.StringCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Path
implements CacheValue,
Comparable<Path> {
    public static final Path ROOT = new Path(null, "", "".hashCode());
    @Nullable
    private final Path parent;
    @NotNull
    private final String name;
    private int hash;

    private Path(@Nullable Path parent, @NotNull String name, int hash) {
        this.parent = parent;
        this.name = name;
        this.hash = hash;
    }

    public Path(@NotNull Path parent, @NotNull String name) {
        this((Path)Preconditions.checkNotNull((Object)parent), (String)Preconditions.checkNotNull((Object)name), -1);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name cannot be the empty String");
    }

    public Path(@NotNull String name) {
        this(null, (String)Preconditions.checkNotNull((Object)name), -1);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name cannot be the empty String");
        Preconditions.checkArgument((name.indexOf(47) == -1 ? 1 : 0) != 0, (String)"name must not contain path separator: {}", (Object[])new Object[]{name});
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Iterable<String> elements() {
        return this.elements(false);
    }

    public boolean isRoot() {
        return this.name.isEmpty();
    }

    @Nullable
    public Path getParent() {
        return this.parent;
    }

    public int length() {
        if (this.isRoot()) {
            return 1;
        }
        int length = 0;
        Path p = this;
        while (p != null) {
            length += p.name.length();
            if (p.parent != null) {
                ++length;
            }
            p = p.parent;
        }
        return length;
    }

    public int getDepth() {
        return this.getNumberOfPathElements(false);
    }

    @NotNull
    public Path getAncestor(int nth) {
        Path p = this;
        while (nth-- > 0 && p.parent != null) {
            p = p.parent;
        }
        return p;
    }

    public boolean isAncestorOf(@NotNull Path other) {
        Preconditions.checkNotNull((Object)other);
        int depthDiff = other.getDepth() - this.getDepth();
        return depthDiff > 0 && Iterables.elementsEqual(this.elements(true), other.getAncestor(depthDiff).elements(true));
    }

    public boolean isAbsolute() {
        Path p = this;
        while (p.parent != null) {
            p = p.parent;
        }
        return p.isRoot();
    }

    @NotNull
    public static Path fromString(@NotNull String path) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)path);
        Path p = null;
        if (PathUtils.isAbsolute((String)path)) {
            p = ROOT;
        }
        for (String name : PathUtils.elements((String)path)) {
            name = StringCache.get(name);
            if (p == null) {
                p = new Path(name);
                continue;
            }
            p = new Path(p, StringCache.get(name));
        }
        if (p == null) {
            throw new IllegalArgumentException("path must not be empty");
        }
        return p;
    }

    @NotNull
    public StringBuilder toStringBuilder(@NotNull StringBuilder sb) {
        if (this.isRoot()) {
            sb.append('/');
        } else {
            this.buildPath(sb);
        }
        return sb;
    }

    public int getMemory() {
        int memory = 0;
        Path p = this;
        while (p.parent != null) {
            memory += 24;
            memory += StringUtils.estimateMemoryUsage((String)this.name);
            p = p.parent;
        }
        return memory;
    }

    @Override
    public int compareTo(@NotNull Path other) {
        int off;
        int corrected;
        if (this == other) {
            return 0;
        }
        Path t = this;
        for (corrected = off = t.getNumberOfPathElements(true) - ((Path)Preconditions.checkNotNull((Object)other)).getNumberOfPathElements(true); corrected > 0; --corrected) {
            t = t.parent;
        }
        while (corrected < 0) {
            other = other.parent;
            ++corrected;
        }
        int cp = Path.comparePath(t, other);
        if (cp != 0) {
            return cp;
        }
        return Integer.signum(off);
    }

    public String toString() {
        if (this.isRoot()) {
            return "/";
        }
        return this.buildPath(new StringBuilder(this.length())).toString();
    }

    public int hashCode() {
        int h = this.hash;
        if (h == -1 && this.parent != null) {
            h = 17;
            h = 37 * h + this.parent.hashCode();
            this.hash = h = 37 * h + this.name.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Path) {
            Path other = (Path)obj;
            return this.name.equals(other.name) && Objects.equals(this.parent, other.parent);
        }
        return false;
    }

    private Iterable<String> elements(boolean withRoot) {
        int size = this.getNumberOfPathElements(withRoot);
        String[] elements = new String[size];
        Path p = this;
        int i = size - 1;
        while (p != null) {
            if (withRoot || !p.isRoot()) {
                elements[i] = p.name;
            }
            p = p.parent;
            --i;
        }
        return Arrays.asList(elements);
    }

    private StringBuilder buildPath(StringBuilder sb) {
        if (this.parent != null) {
            this.parent.buildPath(sb).append("/");
        }
        sb.append(this.name);
        return sb;
    }

    private int getNumberOfPathElements(boolean withRoot) {
        int depth = 0;
        Path p = this;
        while (p != null) {
            if (withRoot || !p.isRoot()) {
                ++depth;
            }
            p = p.parent;
        }
        return depth;
    }

    private static int comparePath(Path a, Path b) {
        int cp;
        if (a.parent != b.parent && (cp = Path.comparePath(a.parent, b.parent)) != 0) {
            return cp;
        }
        return a.name.compareTo(b.name);
    }
}

