/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBranch;
import org.apache.jackrabbit.oak.plugins.document.DocumentRootBuilder;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.EqualsDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;

class ModifiedDocumentNodeState
extends AbstractNodeState {
    private final DocumentNodeStore store;
    private final DocumentNodeStoreBranch branch;
    private final DocumentNodeState base;
    private final NodeState modified;

    ModifiedDocumentNodeState(@NotNull DocumentNodeStore store, @NotNull DocumentNodeStoreBranch branch, @NotNull DocumentNodeState base, @NotNull NodeState modified) {
        this.store = (DocumentNodeStore)Preconditions.checkNotNull((Object)store);
        this.branch = (DocumentNodeStoreBranch)Preconditions.checkNotNull((Object)branch);
        this.base = (DocumentNodeState)((Object)Preconditions.checkNotNull((Object)((Object)base)));
        this.modified = (NodeState)Preconditions.checkNotNull((Object)modified);
    }

    public boolean exists() {
        return this.modified.exists();
    }

    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        return this.modified.getProperties();
    }

    public boolean hasChildNode(@NotNull String name) {
        return this.modified.hasChildNode(name);
    }

    @NotNull
    public NodeState getChildNode(@NotNull String name) throws IllegalArgumentException {
        return this.modified.getChildNode(name);
    }

    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        return this.modified.getChildNodeEntries();
    }

    @NotNull
    public NodeBuilder builder() {
        return new DocumentRootBuilder(this.modified, this.store, this.branch);
    }

    public boolean equals(Object that) {
        ModifiedNodeState modified;
        if (this == that) {
            return true;
        }
        if (that instanceof AbstractDocumentNodeState) {
            AbstractDocumentNodeState other = (AbstractDocumentNodeState)((Object)that);
            if (!this.base.getPath().equals(other.getPath())) {
                return false;
            }
            if (this.revisionEquals(this.base, other)) {
                return EqualsDiff.equals((NodeState)this.base, (NodeState)this.modified);
            }
        } else if (that instanceof ModifiedNodeState && (modified = (ModifiedNodeState)that).getBaseState() == this.base) {
            return EqualsDiff.equals((NodeState)this.modified, (NodeState)modified);
        }
        if (that instanceof NodeState) {
            return AbstractNodeState.equals((NodeState)this.modified, (NodeState)((NodeState)that));
        }
        return false;
    }

    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        if (this == base) {
            return true;
        }
        if (base == EmptyNodeState.EMPTY_NODE || !base.exists()) {
            return EmptyNodeState.compareAgainstEmptyState((NodeState)this, (NodeStateDiff)diff);
        }
        if (this.base == base) {
            return this.modified.compareAgainstBaseState((NodeState)this.base, diff);
        }
        if (base instanceof AbstractDocumentNodeState) {
            AbstractDocumentNodeState other = (AbstractDocumentNodeState)base;
            if (this.base.getPath().equals(other.getPath()) && this.revisionEquals(this.base, other)) {
                return this.modified.compareAgainstBaseState((NodeState)this.base, diff);
            }
        }
        return super.compareAgainstBaseState(base, diff);
    }

    NodeState getBaseState() {
        return this.base;
    }

    private boolean revisionEquals(AbstractDocumentNodeState a, AbstractDocumentNodeState b) {
        RevisionVector rv1 = a.getLastRevision();
        rv1 = rv1 != null ? rv1.asTrunkRevision() : null;
        RevisionVector rv2 = b.getLastRevision();
        rv2 = rv2 != null ? rv2.asTrunkRevision() : null;
        return rv1 != null && rv1.equals(rv2);
    }
}

