/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClient;
import com.mongodb.TransactionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.session.ServerSession;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.jetbrains.annotations.NotNull;

class MongoSessionFactory {
    private final MongoClient client;
    private final ClientSessionOptions options;
    private BsonDocument clusterTime;
    private BsonTimestamp operationTime;

    MongoSessionFactory(MongoClient client) {
        this.client = client;
        this.options = ClientSessionOptions.builder().causallyConsistent(true).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientSession createClientSession() {
        ClientSession s = this.client.startSession(this.options);
        MongoSessionFactory mongoSessionFactory = this;
        synchronized (mongoSessionFactory) {
            s.advanceClusterTime(this.clusterTime);
            s.advanceOperationTime(this.operationTime);
        }
        return new TrackingClientSession(s);
    }

    private class TrackingClientSession
    implements ClientSession {
        private final ClientSession session;

        TrackingClientSession(ClientSession session) {
            this.session = session;
        }

        public ClientSessionOptions getOptions() {
            return this.session.getOptions();
        }

        public boolean isCausallyConsistent() {
            return this.session.isCausallyConsistent();
        }

        public Object getOriginator() {
            return this.session.getOriginator();
        }

        public ServerSession getServerSession() {
            return this.session.getServerSession();
        }

        public BsonTimestamp getOperationTime() {
            return this.session.getOperationTime();
        }

        public void advanceOperationTime(BsonTimestamp operationTime) {
            this.session.advanceOperationTime(operationTime);
        }

        public void advanceClusterTime(BsonDocument clusterTime) {
            this.session.advanceClusterTime(clusterTime);
        }

        public BsonDocument getClusterTime() {
            return this.session.getClusterTime();
        }

        public boolean hasActiveTransaction() {
            return this.session.hasActiveTransaction();
        }

        public boolean notifyMessageSent() {
            return this.session.notifyMessageSent();
        }

        @NotNull
        public TransactionOptions getTransactionOptions() {
            return this.session.getTransactionOptions();
        }

        public void startTransaction() {
            this.session.startTransaction();
        }

        public void startTransaction(@NotNull TransactionOptions options) {
            this.session.startTransaction(options);
        }

        public void commitTransaction() {
            this.session.commitTransaction();
        }

        public void abortTransaction() {
            this.session.abortTransaction();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            TrackingClientSession trackingClientSession = this;
            synchronized (trackingClientSession) {
                this.session.advanceClusterTime(MongoSessionFactory.this.clusterTime);
                MongoSessionFactory.this.clusterTime = this.session.getClusterTime();
                this.session.advanceOperationTime(MongoSessionFactory.this.operationTime);
                MongoSessionFactory.this.operationTime = this.session.getOperationTime();
            }
            this.session.close();
        }
    }
}

