/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.jetbrains.annotations.Nullable;

public class ClusterNodeInfoDocument
extends Document {
    private static final String MIN_ID_VALUE = "0";
    private static final String MAX_ID_VALUE = "a";
    private final long created = Revision.getCurrentTimestamp();

    public long getCreated() {
        return this.created;
    }

    public long getLeaseEndTime() {
        return (Long)Preconditions.checkNotNull((Object)((Long)this.get("leaseEnd")), (Object)"Lease End Time not set");
    }

    public long getStartTime() {
        Long startTime = (Long)this.get("startTime");
        if (startTime == null) {
            startTime = -1L;
        }
        return startTime;
    }

    public boolean isActive() {
        return this.getState() == ClusterNodeInfo.ClusterNodeState.ACTIVE;
    }

    public boolean isBeingRecovered() {
        return this.getRecoveryState() == ClusterNodeInfo.RecoverLockState.ACQUIRED;
    }

    public boolean isRecoveryNeeded(long currentTimeMillis) {
        return this.isActive() && (currentTimeMillis > this.getLeaseEndTime() || this.isBeingRecovered());
    }

    public boolean isBeingRecoveredBy(int clusterId) {
        return Long.valueOf(clusterId).equals(this.getRecoveryBy());
    }

    @Nullable
    public Long getRecoveryBy() {
        return (Long)this.get("recoveryBy");
    }

    public int getClusterId() {
        return Integer.parseInt(this.getId());
    }

    @Override
    public String toString() {
        return this.format();
    }

    public static List<ClusterNodeInfoDocument> all(DocumentStore store) {
        return store.query(Collection.CLUSTER_NODES, MIN_ID_VALUE, MAX_ID_VALUE, Integer.MAX_VALUE);
    }

    private ClusterNodeInfo.ClusterNodeState getState() {
        return ClusterNodeInfo.ClusterNodeState.fromString((String)this.get("state"));
    }

    private ClusterNodeInfo.RecoverLockState getRecoveryState() {
        return ClusterNodeInfo.RecoverLockState.fromString((String)this.get("recoveryLock"));
    }

    public String getLastWrittenRootRev() {
        return (String)this.get("lastWrittenRootRev");
    }

    public boolean isInvisible() {
        Boolean invisible = (Boolean)this.get("invisible");
        return invisible != null ? invisible : false;
    }
}

