/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.file;

import com.google.common.base.Supplier;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.io.File;
import java.util.UUID;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.segment.RecordIdSet;
import org.apache.jackrabbit.oak.plugins.segment.SegmentBlob;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.plugins.segment.file.TarEntryVisitor;
import org.apache.jackrabbit.oak.plugins.segment.file.TarReader;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;

class CompactionGainEstimate
implements TarEntryVisitor {
    private static final Funnel<UUID> UUID_FUNNEL = new Funnel<UUID>(){

        public void funnel(UUID from, PrimitiveSink into) {
            into.putLong(from.getMostSignificantBits());
            into.putLong(from.getLeastSignificantBits());
        }
    };
    private final BloomFilter<UUID> uuids;
    private long totalSize = 0L;
    private long reachableSize = 0L;

    CompactionGainEstimate(SegmentNodeState node, int estimatedBulkCount, Supplier<Boolean> stop) {
        this.uuids = BloomFilter.create(UUID_FUNNEL, (int)estimatedBulkCount);
        this.collectReferencedSegments(node, new RecordIdSet(), stop);
    }

    private void collectReferencedSegments(SegmentNodeState node, RecordIdSet visited, Supplier<Boolean> stop) {
        if (!((Boolean)stop.get()).booleanValue() && visited.addIfNotPresent(node.getRecordId())) {
            this.collectUUID(node.getRecordId().getSegmentId());
            for (PropertyState propertyState : node.getProperties()) {
                if (propertyState instanceof SegmentPropertyState) {
                    this.collectUUID(((SegmentPropertyState)propertyState).getRecordId().getSegmentId());
                }
                for (Blob blob : (Iterable)propertyState.getValue(Type.BINARIES)) {
                    for (SegmentId id : SegmentBlob.getBulkSegmentIds(blob)) {
                        this.collectUUID(id);
                    }
                }
            }
            for (ChildNodeEntry childNodeEntry : node.getChildNodeEntries()) {
                this.collectReferencedSegments((SegmentNodeState)childNodeEntry.getNodeState(), visited, stop);
            }
        }
    }

    private void collectUUID(SegmentId segmentId) {
        this.uuids.put((Object)new UUID(segmentId.getMostSignificantBits(), segmentId.getLeastSignificantBits()));
    }

    public long estimateCompactionGain(long offset) {
        if (this.totalSize == 0L) {
            return 0L;
        }
        return 100L * (this.totalSize - this.reachableSize - offset) / this.totalSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getReachableSize() {
        return this.reachableSize;
    }

    @Override
    public void visit(long msb, long lsb, File file, int offset, int size) {
        UUID uuid = new UUID(msb, lsb);
        int entrySize = TarReader.getEntrySize(size);
        this.totalSize += (long)entrySize;
        if (this.uuids.mightContain((Object)uuid)) {
            this.reachableSize += (long)entrySize;
        }
    }
}

