/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.plugins.segment.Record;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;

class BlockRecord
extends Record {
    private final int size;

    BlockRecord(RecordId id, int size) {
        super(id);
        this.size = size;
    }

    public int read(int position, byte[] buffer, int offset, int length) {
        Preconditions.checkElementIndex((int)position, (int)this.size);
        Preconditions.checkNotNull((Object)buffer);
        Preconditions.checkPositionIndexes((int)offset, (int)(offset + length), (int)buffer.length);
        if (position + length > this.size) {
            length = this.size - position;
        }
        if (length > 0) {
            this.getSegment().readBytes(this.getOffset(position), buffer, offset, length);
        }
        return length;
    }
}

