/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.jackrabbit.oak.segment.aws.AwsContext;
import org.apache.jackrabbit.oak.segment.aws.AwsPersistence;
import org.apache.jackrabbit.oak.segment.aws.Configuration;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"org.apache.jackrabbit.oak.segment.aws.AwsSegmentStoreService"})
public class AwsSegmentStoreService {
    public static final String DEFAULT_ROOT_DIRECTORY = "oak/";
    public static final String DEFAULT_JOURNALTABLE_NAME = "oakjournaltable";
    public static final String DEFAULT_LOCKTABLE_NAME = "oaklocktable";
    public static final String DEFAULT_REGION_NAME = "us-west-2";
    private ServiceRegistration registration;
    private SegmentNodeStorePersistence persistence;

    @Activate
    public void activate(ComponentContext context, Configuration config) throws IOException {
        this.persistence = AwsSegmentStoreService.createAwsPersistence(config);
        this.registration = context.getBundleContext().registerService(SegmentNodeStorePersistence.class.getName(), (Object)this.persistence, (Dictionary)new Properties());
    }

    @Deactivate
    public void deactivate() throws IOException {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        this.persistence = null;
    }

    private static SegmentNodeStorePersistence createAwsPersistence(Configuration configuration) throws IOException {
        AwsContext awsContext = AwsContext.create(configuration);
        AwsPersistence persistence = new AwsPersistence(awsContext);
        return persistence;
    }
}

