/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws.journal;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import java.io.IOException;
import java.util.Date;
import org.apache.jackrabbit.oak.segment.aws.AwsJournalFile;
import org.apache.jackrabbit.oak.segment.aws.DynamoDBClient;
import org.apache.jackrabbit.oak.segment.file.JournalReader;
import org.apache.jackrabbit.oak.segment.file.JournalReaderTest;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.junit.Before;

public class AwsJournalReaderTest
extends JournalReaderTest {
    private DynamoDBClient dynamoDBClient;

    @Before
    public void setup() throws IOException {
        AmazonDynamoDB ddb = DynamoDBEmbedded.create().amazonDynamoDB();
        long time = new Date().getTime();
        this.dynamoDBClient = new DynamoDBClient(ddb, "journaltable-" + time, "locktable-" + time);
        this.dynamoDBClient.ensureTables();
    }

    protected JournalReader createJournalReader(String s) throws IOException {
        String fileName = "journal.log";
        for (String line : s.split("\n")) {
            if (line == null || line.isEmpty()) continue;
            this.dynamoDBClient.putDocument(fileName, line);
        }
        return new JournalReader((JournalFile)new AwsJournalFile(this.dynamoDBClient, fileName));
    }
}

