/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.aws.AwsContext;
import org.apache.jackrabbit.oak.segment.aws.AwsPersistence;
import org.apache.jackrabbit.oak.segment.aws.S3MockRule;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveWriter;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class AwsArchiveManagerTest {
    @ClassRule
    public static final S3MockRule s3Mock = new S3MockRule();
    private AwsContext awsContext;
    private AmazonS3 s3;
    private String bucketName;
    private String rootDirectory = "oak";

    @Before
    public void setup() throws IOException {
        this.s3 = s3Mock.createClient();
        AmazonDynamoDB ddb = DynamoDBEmbedded.create().amazonDynamoDB();
        long time = new Date().getTime();
        this.bucketName = "bucket-" + time;
        this.awsContext = AwsContext.create((AmazonS3)this.s3, (String)this.bucketName, (String)"oak", (AmazonDynamoDB)ddb, (String)("journaltable-" + time), (String)("locktable-" + time));
    }

    @Test
    public void testRecovery() throws IOException {
        SegmentArchiveManager manager = new AwsPersistence(this.awsContext).createArchiveManager(false, false, (IOMonitor)new IOMonitorAdapter(), (FileStoreMonitor)new FileStoreMonitorAdapter(), (RemoteStoreMonitor)new RemoteStoreMonitorAdapter());
        SegmentArchiveWriter writer = manager.create("data00000a.tar");
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (int i = 0; i < 10; ++i) {
            UUID u = UUID.randomUUID();
            writer.writeSegment(u.getMostSignificantBits(), u.getLeastSignificantBits(), new byte[10], 0, 10, 0, 0, false);
            uuids.add(u);
        }
        writer.flush();
        writer.close();
        this.s3.deleteObject(this.bucketName, this.rootDirectory + "/data00000a.tar/0005." + ((UUID)uuids.get(5)).toString());
        LinkedHashMap recovered = new LinkedHashMap();
        manager.recoverEntries("data00000a.tar", recovered);
        Assert.assertEquals(uuids.subList(0, 5), (Object)Lists.newArrayList(recovered.keySet()));
    }

    @Test
    public void testUncleanStop() throws InvalidFileStoreVersionException, IOException, CommitFailedException {
        AwsPersistence p = new AwsPersistence(this.awsContext);
        FileStore fs = FileStoreBuilder.fileStoreBuilder((File)new File("target")).withCustomPersistence((SegmentNodeStorePersistence)p).build();
        SegmentNodeStore segmentNodeStore = SegmentNodeStoreBuilders.builder((FileStore)fs).build();
        NodeBuilder builder = segmentNodeStore.getRoot().builder();
        builder.setProperty("foo", (Object)"bar");
        segmentNodeStore.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        fs.close();
        this.s3.deleteObject(this.bucketName, this.rootDirectory + "/data00000a.tar/closed");
        this.s3.deleteObject(this.bucketName, this.rootDirectory + "/data00000a.tar/data00000a.tar.brf");
        this.s3.deleteObject(this.bucketName, this.rootDirectory + "/data00000a.tar/data00000a.tar.gph");
        fs = FileStoreBuilder.fileStoreBuilder((File)new File("target")).withCustomPersistence((SegmentNodeStorePersistence)p).build();
        segmentNodeStore = SegmentNodeStoreBuilders.builder((FileStore)fs).build();
        Assert.assertEquals((Object)"bar", (Object)segmentNodeStore.getRoot().getString("foo"));
        fs.close();
    }

    @Test
    public void testUncleanStopWithEmptyArchive() throws IOException, CommitFailedException, InvalidFileStoreVersionException {
        AwsPersistence p = new AwsPersistence(this.awsContext);
        FileStore fs = FileStoreBuilder.fileStoreBuilder((File)new File("target")).withCustomPersistence((SegmentNodeStorePersistence)p).build();
        SegmentNodeStore segmentNodeStore = SegmentNodeStoreBuilders.builder((FileStore)fs).build();
        NodeBuilder builder = segmentNodeStore.getRoot().builder();
        builder.setProperty("foo", (Object)"bar");
        segmentNodeStore.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        fs.close();
        fs = FileStoreBuilder.fileStoreBuilder((File)new File("target")).withCustomPersistence((SegmentNodeStorePersistence)p).build();
        segmentNodeStore = SegmentNodeStoreBuilders.builder((FileStore)fs).build();
        builder = segmentNodeStore.getRoot().builder();
        builder.setProperty("foo2", (Object)"bar2");
        segmentNodeStore.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        fs.close();
        S3ObjectSummary segment0000 = (S3ObjectSummary)this.awsContext.directory.listObjects("data00001a.tar/0000.").iterator().next();
        this.s3.deleteObject(segment0000.getBucketName(), segment0000.getKey());
        this.s3.deleteObject(segment0000.getBucketName(), "oak/data00001a.tar/closed");
        fs = FileStoreBuilder.fileStoreBuilder((File)new File("target")).withCustomPersistence((SegmentNodeStorePersistence)p).build();
        segmentNodeStore = SegmentNodeStoreBuilders.builder((FileStore)fs).build();
        Assert.assertEquals((Object)"bar", (Object)segmentNodeStore.getRoot().getString("foo"));
        fs.close();
    }

    @Test
    public void testExists() throws IOException {
        SegmentArchiveManager manager = new AwsPersistence(this.awsContext).createArchiveManager(false, false, (IOMonitor)new IOMonitorAdapter(), (FileStoreMonitor)new FileStoreMonitorAdapter(), (RemoteStoreMonitor)new RemoteStoreMonitorAdapter());
        SegmentArchiveWriter writer = manager.create("data00000a.tar");
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (int i = 0; i < 10; ++i) {
            UUID u = UUID.randomUUID();
            writer.writeSegment(u.getMostSignificantBits(), u.getLeastSignificantBits(), new byte[10], 0, 10, 0, 0, false);
            uuids.add(u);
        }
        writer.flush();
        writer.close();
        Assert.assertTrue((boolean)manager.exists("data00000a.tar"));
        Assert.assertFalse((boolean)manager.exists("data00001a.tar"));
    }

    @Test
    public void testArchiveExistsAfterFlush() throws IOException {
        SegmentArchiveManager manager = new AwsPersistence(this.awsContext).createArchiveManager(false, false, (IOMonitor)new IOMonitorAdapter(), (FileStoreMonitor)new FileStoreMonitorAdapter(), (RemoteStoreMonitor)new RemoteStoreMonitorAdapter());
        SegmentArchiveWriter writer = manager.create("data00000a.tar");
        Assert.assertFalse((boolean)manager.exists("data00000a.tar"));
        UUID u = UUID.randomUUID();
        writer.writeSegment(u.getMostSignificantBits(), u.getLeastSignificantBits(), new byte[10], 0, 10, 0, 0, false);
        writer.flush();
        Assert.assertTrue((boolean)manager.exists("data00000a.tar"));
    }
}

