/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws.tool;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.PrintWriter;
import org.apache.jackrabbit.oak.segment.aws.tool.AwsSegmentStoreMigrator;
import org.apache.jackrabbit.oak.segment.aws.tool.AwsToolUtils;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;

public class AwsSegmentCopy {
    private final String source;
    private final String destination;
    private final PrintWriter outWriter;
    private final PrintWriter errWriter;
    private final Integer revisionCount;
    private SegmentNodeStorePersistence srcPersistence;
    private SegmentNodeStorePersistence destPersistence;

    public static Builder builder() {
        return new Builder();
    }

    public static boolean canExecute(String source, String destination) {
        return source.startsWith("aws:") || destination.startsWith("aws:");
    }

    public AwsSegmentCopy(Builder builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.srcPersistence = builder.srcPersistence;
        this.destPersistence = builder.destPersistence;
        this.revisionCount = builder.revisionsCount;
        this.outWriter = builder.outWriter;
        this.errWriter = builder.errWriter;
    }

    public int run() {
        Stopwatch watch = Stopwatch.createStarted();
        AwsToolUtils.SegmentStoreType srcType = AwsToolUtils.storeTypeFromPathOrUri(this.source);
        AwsToolUtils.SegmentStoreType destType = AwsToolUtils.storeTypeFromPathOrUri(this.destination);
        String srcDescription = AwsToolUtils.storeDescription(srcType, this.source);
        String destDescription = AwsToolUtils.storeDescription(destType, this.destination);
        try {
            if (this.srcPersistence == null || this.destPersistence == null) {
                this.srcPersistence = AwsToolUtils.newSegmentNodeStorePersistence(srcType, this.source);
                this.destPersistence = AwsToolUtils.newSegmentNodeStorePersistence(destType, this.destination);
            }
            AwsToolUtils.printMessage(this.outWriter, "Started segment-copy transfer!", new Object[0]);
            AwsToolUtils.printMessage(this.outWriter, "Source: {0}", srcDescription);
            AwsToolUtils.printMessage(this.outWriter, "Destination: {0}", destDescription);
            AwsSegmentStoreMigrator migrator = new AwsSegmentStoreMigrator.Builder().withSourcePersistence(this.srcPersistence, srcDescription).withTargetPersistence(this.destPersistence, destDescription).withRevisionCount(this.revisionCount).build();
            migrator.migrate();
        }
        catch (Exception e) {
            watch.stop();
            AwsToolUtils.printMessage(this.errWriter, "A problem occured while copying archives from {0} to {1} ", this.source, this.destination);
            e.printStackTrace(this.errWriter);
            return 1;
        }
        watch.stop();
        AwsToolUtils.printMessage(this.outWriter, "Segment-copy succeeded in {0}", AwsToolUtils.printableStopwatch(watch));
        return 0;
    }

    public static class Builder {
        private String source;
        private String destination;
        private SegmentNodeStorePersistence srcPersistence;
        private SegmentNodeStorePersistence destPersistence;
        private PrintWriter outWriter;
        private PrintWriter errWriter;
        private Integer revisionsCount = Integer.MAX_VALUE;

        private Builder() {
        }

        public Builder withSource(String source) {
            this.source = (String)Preconditions.checkNotNull((Object)source);
            return this;
        }

        public Builder withDestination(String destination) {
            this.destination = (String)Preconditions.checkNotNull((Object)destination);
            return this;
        }

        public Builder withSrcPersistencee(SegmentNodeStorePersistence srcPersistence) {
            this.srcPersistence = (SegmentNodeStorePersistence)Preconditions.checkNotNull((Object)srcPersistence);
            return this;
        }

        public Builder withDestPersistence(SegmentNodeStorePersistence destPersistence) {
            this.destPersistence = (SegmentNodeStorePersistence)Preconditions.checkNotNull((Object)destPersistence);
            return this;
        }

        public Builder withOutWriter(PrintWriter outWriter) {
            this.outWriter = outWriter;
            return this;
        }

        public Builder withErrWriter(PrintWriter errWriter) {
            this.errWriter = errWriter;
            return this;
        }

        public Builder withRevisionsCount(Integer revisionsCount) {
            this.revisionsCount = revisionsCount;
            return this;
        }

        public AwsSegmentCopy build() {
            if (this.srcPersistence == null && this.destPersistence == null) {
                Preconditions.checkNotNull((Object)this.source);
                Preconditions.checkNotNull((Object)this.destination);
            }
            return new AwsSegmentCopy(this);
        }
    }
}

