/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.metrics.RequestMetricCollector;
import java.util.Optional;

public class GetLockOptions {
    private final String partitionKey;
    private final Optional<String> sortKey;
    private final boolean deleteLockOnRelease;
    private final Optional<RequestMetricCollector> requestMetricCollector;

    public static GetLockOptionsBuilder builder(String partitionKey) {
        return new GetLockOptionsBuilder(partitionKey);
    }

    private GetLockOptions(String key, Optional<String> sortKey, boolean deleteLockOnRelease, Optional<RequestMetricCollector> requestMetricCollector2) {
        this.partitionKey = key;
        this.sortKey = sortKey;
        this.deleteLockOnRelease = deleteLockOnRelease;
        this.requestMetricCollector = requestMetricCollector2;
    }

    String getPartitionKey() {
        return this.partitionKey;
    }

    Optional<String> getSortKey() {
        return this.sortKey;
    }

    boolean isDeleteLockOnRelease() {
        return this.deleteLockOnRelease;
    }

    Optional<RequestMetricCollector> getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public static class GetLockOptionsBuilder {
        private String partitionKey;
        private Optional<String> sortKey = Optional.empty();
        private boolean deleteLockOnRelease = false;
        private Optional<RequestMetricCollector> requestMetricCollector = Optional.empty();

        GetLockOptionsBuilder(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public GetLockOptionsBuilder withSortKey(String sortKey) {
            this.sortKey = Optional.ofNullable(sortKey);
            return this;
        }

        public GetLockOptionsBuilder withDeleteLockOnRelease(boolean deleteLockOnRelease) {
            this.deleteLockOnRelease = deleteLockOnRelease;
            return this;
        }

        public GetLockOptionsBuilder withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
            this.requestMetricCollector = Optional.ofNullable(requestMetricCollector);
            return this;
        }

        public GetLockOptions build() {
            return new GetLockOptions(this.partitionKey, this.sortKey, this.deleteLockOnRelease, this.requestMetricCollector);
        }

        public String toString() {
            return "GetLockOptions.GetLockOptionsBuilder(partitionKey=" + this.partitionKey + ", sortKey=" + this.sortKey + ", deleteLockOnRelease=" + this.deleteLockOnRelease + ", requestMetricCollector=" + this.requestMetricCollector + ")";
        }
    }
}

