/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jackrabbit.oak.segment.aws.AwsJournalFile;
import org.apache.jackrabbit.oak.segment.aws.DynamoDBClient;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileWriter;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsJournalFileConcurrencyIT {
    private static final Logger log = LoggerFactory.getLogger(AwsJournalFileConcurrencyIT.class);
    private DynamoDBClient dynamoDBClient;

    @Before
    public void setup() throws IOException, InterruptedException {
        AmazonDynamoDB ddb = DynamoDBEmbedded.create().amazonDynamoDB();
        long time = new Date().getTime();
        this.dynamoDBClient = new DynamoDBClient(ddb, "journaltable-" + time, "locktable-" + time);
        this.dynamoDBClient.ensureTables();
        this.writeJournalLines(300, 0);
        log.info("Finished writing initial content to journal!");
    }

    @AfterClass
    public static void cleanupContainer() {
    }

    @Test
    public void testConcurrency() throws Exception {
        AtomicBoolean stop = new AtomicBoolean();
        AtomicReference exContainer = new AtomicReference();
        Thread producer = new Thread(() -> {
            try {
                while (!stop.get()) {
                    this.writeJournalLines(300, 100);
                }
            }
            catch (Exception e) {
                exContainer.set(e);
                stop.set(true);
            }
        });
        Thread consumer = new Thread(() -> {
            try {
                while (!stop.get()) {
                    this.readJournal();
                }
            }
            catch (IOException e) {
                exContainer.set(e);
                stop.set(true);
            }
        });
        producer.start();
        consumer.start();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 30000L && !stop.get()) {
            Thread.sleep(100L);
        }
        stop.set(true);
        producer.join();
        consumer.join();
        if (exContainer.get() != null) {
            throw (Exception)exContainer.get();
        }
    }

    private void readJournal() throws IOException {
        AwsJournalFile file = new AwsJournalFile(this.dynamoDBClient, "journal.log");
        try (JournalFileReader reader = file.openJournalReader();){
            String line = null;
            while ((line = reader.readLine()) != null) {
                log.info(line);
            }
        }
    }

    private void writeJournalLines(int lines, int delayMillis) throws IOException, InterruptedException {
        AwsJournalFile file = new AwsJournalFile(this.dynamoDBClient, "journal.log");
        try (JournalFileWriter writer = file.openJournalWriter();){
            for (int i = 0; i < lines; ++i) {
                writer.writeLine(String.format("%4X - %s", i, UUID.randomUUID().toString()));
                Thread.sleep(delayMillis);
            }
        }
    }
}

