/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.aws.S3Directory;
import org.apache.jackrabbit.oak.segment.remote.AbstractRemoteSegmentArchiveWriter;
import org.apache.jackrabbit.oak.segment.remote.RemoteSegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.remote.RemoteUtilities;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;

public class AwsSegmentArchiveWriter
extends AbstractRemoteSegmentArchiveWriter {
    private final S3Directory directory;
    private final String archiveName;

    public AwsSegmentArchiveWriter(S3Directory directory, String archiveName, IOMonitor ioMonitor, FileStoreMonitor monitor) {
        super(ioMonitor, monitor);
        this.directory = directory;
        this.archiveName = archiveName;
    }

    public String getName() {
        return this.archiveName;
    }

    protected void doWriteArchiveEntry(RemoteSegmentArchiveEntry indexEntry, byte[] data, int offset, int size) throws IOException {
        long msb = indexEntry.getMsb();
        long lsb = indexEntry.getLsb();
        String segmentName = RemoteUtilities.getSegmentFileName((RemoteSegmentArchiveEntry)indexEntry);
        String fullName = this.directory.getPath() + segmentName;
        this.ioMonitor.beforeSegmentWrite(new File(fullName), msb, lsb, size);
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.directory.writeObject(segmentName, data);
        this.ioMonitor.afterSegmentWrite(new File(fullName), msb, lsb, size, stopwatch.elapsed(TimeUnit.NANOSECONDS));
    }

    protected Buffer doReadArchiveEntry(RemoteSegmentArchiveEntry indexEntry) throws IOException {
        return this.directory.readObjectToBuffer(RemoteUtilities.getSegmentFileName((RemoteSegmentArchiveEntry)indexEntry), RemoteUtilities.OFF_HEAP);
    }

    protected void doWriteDataFile(byte[] data, String extension) throws IOException {
        this.directory.writeObject(this.getName() + extension, data);
    }

    protected void afterQueueClosed() throws IOException {
        this.writeIndex();
        this.directory.writeObject("closed", new byte[0]);
    }

    private void writeIndex() throws IOException {
        Buffer buffer = Buffer.allocate((int)(this.index.size() * 33));
        for (RemoteSegmentArchiveEntry entry : this.index.values()) {
            buffer.putLong(entry.getMsb());
            buffer.putLong(entry.getLsb());
            buffer.putInt(entry.getPosition());
            buffer.putInt(entry.getLength());
            buffer.putInt(entry.getGeneration());
            buffer.putInt(entry.getFullGeneration());
            buffer.put(entry.isCompacted() ? (byte)1 : 0);
        }
        this.directory.writeObject(this.archiveName + ".idx", buffer.array());
    }

    protected void afterQueueFlushed() throws IOException {
        this.writeIndex();
    }
}

