/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.persistence.split;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import com.amazonaws.services.s3.AmazonS3;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.aws.AwsContext;
import org.apache.jackrabbit.oak.segment.aws.AwsPersistence;
import org.apache.jackrabbit.oak.segment.aws.S3MockRule;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.tar.TarPersistence;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.BinaryReferencesIndexLoader;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.InvalidBinaryReferencesIndexException;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.split.SplitPersistence;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SplitPersistenceTest {
    @ClassRule
    public static final S3MockRule s3Mock = new S3MockRule();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder(new File("target"));
    private SegmentNodeStore base;
    private SegmentNodeStore split;
    private FileStore baseFileStore;
    private FileStore splitFileStore;
    private SegmentNodeStorePersistence splitPersistence;

    @Before
    public void setup() throws IOException, InvalidFileStoreVersionException, CommitFailedException {
        AmazonS3 s3 = s3Mock.createClient();
        AmazonDynamoDB ddb = DynamoDBEmbedded.create().amazonDynamoDB();
        long time = new Date().getTime();
        AwsContext awsContext = AwsContext.create((AmazonS3)s3, (String)("bucket-" + time), (String)"oak", (AmazonDynamoDB)ddb, (String)("journaltable-" + time), (String)("locktable-" + time));
        AwsPersistence sharedPersistence = new AwsPersistence(awsContext);
        this.baseFileStore = FileStoreBuilder.fileStoreBuilder((File)this.folder.newFolder()).withCustomPersistence((SegmentNodeStorePersistence)sharedPersistence).build();
        this.base = SegmentNodeStoreBuilders.builder((FileStore)this.baseFileStore).build();
        NodeBuilder builder = this.base.getRoot().builder();
        builder.child("foo").child("bar").setProperty("version", (Object)"v1");
        this.base.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        this.baseFileStore.flush();
        TarPersistence localPersistence = new TarPersistence(this.folder.newFolder());
        this.splitPersistence = new SplitPersistence((SegmentNodeStorePersistence)sharedPersistence, (SegmentNodeStorePersistence)localPersistence);
        this.splitFileStore = FileStoreBuilder.fileStoreBuilder((File)this.folder.newFolder()).withCustomPersistence(this.splitPersistence).build();
        this.split = SegmentNodeStoreBuilders.builder((FileStore)this.splitFileStore).build();
    }

    @After
    public void tearDown() {
        if (this.splitFileStore != null) {
            this.splitFileStore.close();
        }
        if (this.baseFileStore != null) {
            this.baseFileStore.close();
        }
    }

    @Test
    public void testBaseNodeAvailable() {
        Assert.assertEquals((Object)"v1", (Object)this.split.getRoot().getChildNode("foo").getChildNode("bar").getString("version"));
    }

    @Test
    public void testChangesAreLocalForBaseRepository() throws CommitFailedException {
        NodeBuilder builder = this.base.getRoot().builder();
        builder.child("foo").child("bar").setProperty("version", (Object)"v2");
        this.base.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        Assert.assertEquals((Object)"v1", (Object)this.split.getRoot().getChildNode("foo").getChildNode("bar").getString("version"));
    }

    @Test
    public void testChangesAreLocalForSplitRepository() throws CommitFailedException {
        NodeBuilder builder = this.split.getRoot().builder();
        builder.child("foo").child("bar").setProperty("version", (Object)"v2");
        this.split.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        Assert.assertEquals((Object)"v1", (Object)this.base.getRoot().getChildNode("foo").getChildNode("bar").getString("version"));
    }

    @Test
    public void testBinaryReferencesAreNotNull() throws IOException, InvalidBinaryReferencesIndexException {
        this.splitFileStore.close();
        this.splitFileStore = null;
        SegmentArchiveManager manager = this.splitPersistence.createArchiveManager(true, false, (IOMonitor)new IOMonitorAdapter(), (FileStoreMonitor)new FileStoreMonitorAdapter(), (RemoteStoreMonitor)new RemoteStoreMonitorAdapter());
        for (String archive : manager.listArchives()) {
            SegmentArchiveReader reader = manager.open(archive);
            BinaryReferencesIndexLoader.parseBinaryReferencesIndex((Buffer)reader.getBinaryReferences());
            reader.close();
        }
    }
}

