/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.spi.blob.stats.BlobStatsCollector;
import org.apache.jackrabbit.oak.spi.blob.stats.BlobStoreStatsMBean;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.stats.TimeSeriesAverage;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreStats
extends AnnotatedStandardMBean
implements BlobStoreStatsMBean,
BlobStatsCollector {
    private final Logger opsLogger = LoggerFactory.getLogger((String)"org.apache.jackrabbit.oak.operations.blobs");
    private static final String BLOB_DOWNLOAD_COUNT = "BLOB_DOWNLOAD_COUNT";
    private static final String BLOB_UPLOADS = "BLOB_UPLOADS";
    private static final String BLOB_DOWNLOADS = "BLOB_DOWNLOADS";
    private static final String BLOB_UPLOAD_COUNT = "BLOB_UPLOAD_COUNT";
    private final StatisticsProvider statisticsProvider;
    private final HistogramStats uploadHisto;
    private final MeterStats uploadCount;
    private final MeterStats uploadSizeSeries;
    private final MeterStats uploadTimeSeries;
    private final TimeSeries uploadRateSeries;
    private final HistogramStats downloadHisto;
    private final MeterStats downloadCount;
    private final MeterStats downloadSizeSeries;
    private final MeterStats downloadTimeSeries;
    private final TimeSeries downloadRateSeries;
    private final TimeUnit recordedTimeUnit = TimeUnit.NANOSECONDS;

    public BlobStoreStats(@NotNull StatisticsProvider sp) {
        super(BlobStoreStatsMBean.class);
        this.statisticsProvider = (StatisticsProvider)Preconditions.checkNotNull((Object)sp);
        this.uploadHisto = sp.getHistogram(BLOB_UPLOADS, StatsOptions.DEFAULT);
        this.uploadCount = sp.getMeter(BLOB_UPLOAD_COUNT, StatsOptions.DEFAULT);
        this.uploadSizeSeries = sp.getMeter("BLOB_UPLOAD_SIZE", StatsOptions.TIME_SERIES_ONLY);
        this.uploadTimeSeries = sp.getMeter("BLOB_UPLOAD_TIME", StatsOptions.TIME_SERIES_ONLY);
        this.uploadRateSeries = this.getAvgTimeSeries("BLOB_UPLOAD_SIZE", "BLOB_UPLOAD_TIME");
        this.downloadHisto = sp.getHistogram(BLOB_DOWNLOADS, StatsOptions.DEFAULT);
        this.downloadCount = sp.getMeter(BLOB_DOWNLOAD_COUNT, StatsOptions.DEFAULT);
        this.downloadSizeSeries = sp.getMeter("BLOB_DOWNLOAD_SIZE", StatsOptions.TIME_SERIES_ONLY);
        this.downloadTimeSeries = sp.getMeter("BLOB_DOWNLOAD_TIME", StatsOptions.TIME_SERIES_ONLY);
        this.downloadRateSeries = this.getAvgTimeSeries("BLOB_DOWNLOAD_SIZE", "BLOB_DOWNLOAD_TIME");
    }

    public void uploaded(long timeTaken, TimeUnit unit, long size) {
        this.uploadHisto.update(size);
        this.uploadSizeSeries.mark(size);
        this.uploadTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Uploaded {} bytes in {} ms", (Object)size, (Object)unit.toMillis(timeTaken));
    }

    public void downloaded(String blobId, long timeTaken, TimeUnit unit, long size) {
        this.downloadHisto.update(size);
        this.downloadSizeSeries.mark(size);
        this.downloadTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Downloaded {} - {} bytes in {} ms", new Object[]{blobId, size, unit.toMillis(timeTaken)});
    }

    public void uploadCompleted(String blobId) {
        this.uploadCount.mark();
        this.opsLogger.debug("Upload completed - {}", (Object)blobId);
    }

    public void downloadCompleted(String blobId) {
        this.downloadCount.mark();
        this.opsLogger.debug("Download completed - {}", (Object)blobId);
    }

    public long getUploadTotalSize() {
        return this.uploadSizeSeries.getCount();
    }

    public long getUploadCount() {
        return this.uploadCount.getCount();
    }

    public long getUploadTotalSeconds() {
        return this.recordedTimeUnit.toSeconds(this.uploadTimeSeries.getCount());
    }

    public long getDownloadTotalSize() {
        return this.downloadSizeSeries.getCount();
    }

    public long getDownloadCount() {
        return this.downloadCount.getCount();
    }

    public long getDownloadTotalSeconds() {
        return this.recordedTimeUnit.toSeconds(this.downloadTimeSeries.getCount());
    }

    public String blobStoreInfoAsString() {
        return String.format("Uploads - size = %s, count = %d%nDownloads - size = %s, count = %d", IOUtils.humanReadableByteCount((long)this.getUploadTotalSize()), this.getUploadCount(), IOUtils.humanReadableByteCount((long)this.getDownloadTotalSize()), this.getDownloadCount());
    }

    public CompositeData getUploadSizeHistory() {
        return this.getTimeSeriesData(BLOB_UPLOADS, "Blob Uploads (bytes)");
    }

    public CompositeData getDownloadSizeHistory() {
        return this.getTimeSeriesData(BLOB_DOWNLOADS, "Blob Downloads (bytes)");
    }

    public CompositeData getUploadRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.uploadRateSeries, (String)"Blob uploads bytes/secs");
    }

    public CompositeData getDownloadRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.downloadRateSeries, (String)"Blob downloads bytes/secs");
    }

    public CompositeData getUploadCountHistory() {
        return this.getTimeSeriesData(BLOB_UPLOAD_COUNT, "Blob Upload Counts");
    }

    public CompositeData getDownloadCountHistory() {
        return this.getTimeSeriesData(BLOB_DOWNLOAD_COUNT, "Blob Download Counts");
    }

    private CompositeData getTimeSeriesData(String name, String desc) {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(name), (String)desc);
    }

    private TimeSeries getTimeSeries(String name) {
        return this.statisticsProvider.getStats().getTimeSeries(name, true);
    }

    private TimeSeries getAvgTimeSeries(String nameValue, String nameCounter) {
        return new TimeSeriesAverage(this.getTimeSeries(nameValue), (TimeSeries)new UnitConvertingTimeSeries(this.getTimeSeries(nameCounter), this.recordedTimeUnit, TimeUnit.SECONDS));
    }

    private static class UnitConvertingTimeSeries
    implements TimeSeries {
        private final TimeSeries series;
        private final TimeUnit source;
        private final TimeUnit dest;

        public UnitConvertingTimeSeries(TimeSeries series, TimeUnit source, TimeUnit dest) {
            this.series = series;
            this.source = source;
            this.dest = dest;
        }

        public long[] getValuePerSecond() {
            return this.convert(this.series.getValuePerSecond());
        }

        public long[] getValuePerMinute() {
            return this.convert(this.series.getValuePerMinute());
        }

        public long[] getValuePerHour() {
            return this.convert(this.series.getValuePerHour());
        }

        public long[] getValuePerWeek() {
            return this.convert(this.series.getValuePerWeek());
        }

        public long getMissingValue() {
            return 0L;
        }

        private long[] convert(long[] timings) {
            for (int i = 0; i < timings.length; ++i) {
                timings[i] = this.dest.convert(timings[i], this.source);
            }
            return timings;
        }
    }
}

