/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.LazyFileInputStream;
import org.apache.jackrabbit.oak.spi.blob.AbstractDataRecord;
import org.apache.jackrabbit.oak.spi.blob.AbstractSharedBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSBackend
extends AbstractSharedBackend {
    private static final Logger LOG = LoggerFactory.getLogger(FSBackend.class);
    public static final String FS_BACKEND_PATH = "fsBackendPath";
    private static final int ACCESS_TIME_RESOLUTION = 2000;
    private Properties properties;
    private String fsPath;
    private File fsPathDir;

    public void init() throws DataStoreException {
        boolean created;
        this.fsPath = this.properties.getProperty(FS_BACKEND_PATH);
        if (this.fsPath == null || "".equals(this.fsPath)) {
            throw new DataStoreException("Could not initialize FSBackend from " + this.properties + ". [" + FS_BACKEND_PATH + "] property not found.");
        }
        this.fsPath = FilenameUtils.normalizeNoEndSeparator((String)this.fsPath);
        this.fsPathDir = new File(this.fsPath);
        if (this.fsPathDir.exists() && this.fsPathDir.isFile()) {
            throw new DataStoreException("Can not create a directory because a file exists with the same name: " + this.fsPath);
        }
        if (!this.fsPathDir.exists() && !(created = this.fsPathDir.mkdirs())) {
            throw new DataStoreException("Could not create directory: " + this.fsPathDir.getAbsolutePath());
        }
    }

    public InputStream read(DataIdentifier identifier) throws DataStoreException {
        File file = FSBackend.getFile(identifier, this.fsPathDir);
        try {
            return new LazyFileInputStream(file);
        }
        catch (IOException e) {
            throw new DataStoreException("Error opening input stream of " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataIdentifier identifier, File file) throws DataStoreException {
        File dest = FSBackend.getFile(identifier, this.fsPathDir);
        FSBackend fSBackend = this;
        synchronized (fSBackend) {
            if (dest.exists()) {
                long now = System.currentTimeMillis();
                if (FSBackend.getLastModified(dest) < now + 2000L) {
                    FSBackend.setLastModified(dest, now + 2000L);
                }
            } else {
                try {
                    FileUtils.copyFile((File)file, (File)dest);
                }
                catch (IOException ie) {
                    LOG.error("failed to copy [{}] to [{}]", (Object)file.getAbsolutePath(), (Object)dest.getAbsolutePath());
                    throw new DataStoreException("Not able to write file [" + identifier + "]", (Throwable)ie);
                }
            }
        }
    }

    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        long start = System.currentTimeMillis();
        File file = FSBackend.getFile(identifier, this.fsPathDir);
        if (!file.exists() || !file.isFile()) {
            LOG.info("getRecord:Identifier [{}] not found. Took [{}] ms.", (Object)identifier, (Object)(System.currentTimeMillis() - start));
            throw new DataStoreException("Identifier [" + identifier + "] not found.");
        }
        return new FSBackendDataRecord(this, identifier, file);
    }

    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        return Files.fileTreeTraverser().postOrderTraversal((Object)this.fsPathDir).filter((Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                return input.isFile() && !FilenameUtils.normalizeNoEndSeparator((String)input.getParent()).equals(FSBackend.this.fsPath);
            }
        }).transform((Function)new Function<File, DataIdentifier>(){

            public DataIdentifier apply(File input) {
                return new DataIdentifier(input.getName());
            }
        }).iterator();
    }

    public boolean exists(DataIdentifier identifier) throws DataStoreException {
        File file = FSBackend.getFile(identifier, this.fsPathDir);
        return file.exists() && file.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(DataIdentifier identifier) throws DataStoreException {
        File file = FSBackend.getFile(identifier, this.fsPathDir);
        FSBackend fSBackend = this;
        synchronized (fSBackend) {
            if (file.exists()) {
                if (file.delete()) {
                    this.deleteEmptyParentDirs(file);
                } else {
                    LOG.warn("Failed to delete file " + file.getAbsolutePath());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetadataRecord(InputStream input, String name) throws DataStoreException {
        try {
            File file = new File(this.fsPathDir, name);
            FileOutputStream os = new FileOutputStream(file);
            try {
                IOUtils.copyLarge((InputStream)input, (OutputStream)os);
            }
            finally {
                Closeables.close((Closeable)os, (boolean)true);
                Closeables.close((Closeable)input, (boolean)true);
            }
        }
        catch (IOException e) {
            LOG.error("Exception while adding metadata record with name {}, {}", new Object[]{name, e});
            throw new DataStoreException("Could not add root record", (Throwable)e);
        }
    }

    public void addMetadataRecord(File input, String name) throws DataStoreException {
        try {
            File file = new File(this.fsPathDir, name);
            FileUtils.copyFile((File)input, (File)file);
        }
        catch (IOException e) {
            LOG.error("Exception while adding metadata record file {} with name {}, {}", new Object[]{input, name, e});
            throw new DataStoreException("Could not add root record", (Throwable)e);
        }
    }

    public DataRecord getMetadataRecord(String name) {
        for (File file : FileFilterUtils.filter((IOFileFilter)FileFilterUtils.nameFileFilter((String)name), (File[])this.fsPathDir.listFiles())) {
            if (file.isDirectory()) continue;
            return new FSBackendDataRecord(this, new DataIdentifier(file.getName()), file);
        }
        return null;
    }

    public List<DataRecord> getAllMetadataRecords(String prefix) {
        ArrayList<DataRecord> rootRecords = new ArrayList<DataRecord>();
        for (File file : FileFilterUtils.filterList((IOFileFilter)FileFilterUtils.prefixFileFilter((String)prefix), (File[])this.fsPathDir.listFiles())) {
            if (file.isDirectory()) continue;
            rootRecords.add((DataRecord)new FSBackendDataRecord(this, new DataIdentifier(file.getName()), file));
        }
        return rootRecords;
    }

    public boolean deleteMetadataRecord(String name) {
        for (File file : FileFilterUtils.filterList((IOFileFilter)FileFilterUtils.nameFileFilter((String)name), (File[])this.fsPathDir.listFiles())) {
            if (file.isDirectory()) continue;
            if (!file.delete()) {
                LOG.warn("Failed to delete root record {} ", new Object[]{file.getAbsolutePath()});
                continue;
            }
            return true;
        }
        return false;
    }

    public void deleteAllMetadataRecords(String prefix) {
        for (File file : FileFilterUtils.filterList((IOFileFilter)FileFilterUtils.prefixFileFilter((String)prefix), (File[])this.fsPathDir.listFiles())) {
            if (file.isDirectory() || file.delete()) continue;
            LOG.warn("Failed to delete root record {} ", new Object[]{file.getAbsolutePath()});
        }
    }

    public Iterator<DataRecord> getAllRecords() {
        final FSBackend backend = this;
        return Files.fileTreeTraverser().postOrderTraversal((Object)this.fsPathDir).filter((Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                return input.isFile() && !FilenameUtils.normalizeNoEndSeparator((String)input.getParent()).equals(FSBackend.this.fsPath);
            }
        }).transform((Function)new Function<File, DataRecord>(){

            public DataRecord apply(File input) {
                return new FSBackendDataRecord(backend, new DataIdentifier(input.getName()), input);
            }
        }).iterator();
    }

    public void close() throws DataStoreException {
    }

    public byte[] getOrCreateReferenceKey() throws DataStoreException {
        File file = new File(this.fsPathDir, "reference.key");
        try {
            if (file.exists()) {
                return FileUtils.readFileToByteArray((File)file);
            }
            byte[] key = super.getOrCreateReferenceKey();
            FileUtils.writeByteArrayToFile((File)file, (byte[])key);
            return key;
        }
        catch (IOException e) {
            throw new DataStoreException("Unable to access reference key file " + file.getPath(), (Throwable)e);
        }
    }

    private static File getFile(DataIdentifier identifier, File root) {
        String string = identifier.toString();
        File file = root;
        file = new File(file, string.substring(0, 2));
        file = new File(file, string.substring(2, 4));
        file = new File(file, string.substring(4, 6));
        return new File(file, string);
    }

    private static long getLastModified(File file) throws DataStoreException {
        long lastModified = file.lastModified();
        if (lastModified == 0L) {
            throw new DataStoreException("Failed to read record modified date: " + file.getAbsolutePath());
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLastModified(File file, long time) throws DataStoreException {
        if (!file.setLastModified(time)) {
            if (!file.canWrite()) {
                return;
            }
            try (RandomAccessFile r = new RandomAccessFile(file, "rw");){
                r.setLength(r.length());
            }
            catch (IOException e) {
                throw new DataStoreException("An IO Exception occurred while trying to set the last modified date: " + file.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    private void deleteEmptyParentDirs(File file) {
        File parent = file.getParentFile();
        try {
            while (FileUtils.directoryContains((File)this.fsPathDir, (File)parent)) {
                String[] entries = parent.list();
                if (entries == null) {
                    LOG.warn("Failed to list directory {}", (Object)parent.getAbsolutePath());
                } else if (entries.length <= 0) {
                    boolean deleted = parent.delete();
                    LOG.debug("Deleted parent [{}] of file [{}]: {}", new Object[]{parent, file.getAbsolutePath(), deleted});
                    parent = parent.getParentFile();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            LOG.warn("Error in parents deletion for " + file.getAbsoluteFile(), (Throwable)e);
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    class FSBackendDataRecord
    extends AbstractDataRecord {
        private long length;
        private long lastModified;
        private File file;

        public FSBackendDataRecord(@Nonnull AbstractSharedBackend backend, @Nonnull DataIdentifier identifier, File file) {
            super(backend, identifier);
            this.file = file;
            this.length = file.length();
            this.lastModified = file.lastModified();
        }

        public long getLength() throws DataStoreException {
            return this.length;
        }

        public InputStream getStream() throws DataStoreException {
            try {
                return new LazyFileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                LOG.error("Error in returning stream", (Throwable)e);
                throw new DataStoreException((Throwable)e);
            }
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public String toString() {
            return "S3DataRecord{identifier=" + this.getIdentifier() + ", length=" + this.length + ", lastModified=" + this.lastModified + '}';
        }
    }
}

