/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.commons.beanutils.BeanMap;
import org.apache.jackrabbit.j2ee.ServletExceptionWithCause;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(AbstractConfig.class);
    protected boolean valid;
    private BeanMap map = new BeanMap((Object)this);

    public void init(Properties props) throws ServletException {
        for (String string : props.keySet()) {
            String mapName = this.toMapName(string, '.');
            try {
                if (!this.map.containsKey((Object)mapName)) continue;
                this.map.put((Object)mapName, (Object)props.getProperty(string));
            }
            catch (Exception e) {
                throw new ServletExceptionWithCause("Invalid configuration property: " + string, (Throwable)e);
            }
        }
    }

    public void init(ServletConfig ctx) throws ServletException {
        Enumeration names = ctx.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String mapName = this.toMapName(name, '-');
            try {
                if (!this.map.containsKey((Object)mapName)) continue;
                this.map.put((Object)mapName, (Object)ctx.getInitParameter(name));
            }
            catch (Exception e) {
                throw new ServletExceptionWithCause("Invalid servlet configuration option: " + name, (Throwable)e);
            }
        }
    }

    public String toMapName(String name, char delim) {
        StringBuffer ret = new StringBuffer();
        String[] elems = Text.explode((String)name, (int)delim);
        ret.append(elems[0]);
        for (int i = 1; i < elems.length; ++i) {
            ret.append(elems[i].substring(0, 1).toUpperCase());
            ret.append(elems[i].substring(1));
        }
        return ret.toString();
    }

    public void validate() {
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void logInfos() {
        log.info("Configuration of {}", (Object)Text.getName((String)this.getClass().getName(), (char)'.'));
        log.info("----------------------------------------------");
        for (String name : this.map.keySet()) {
            log.info("  {}: {}", (Object)name, this.map.get((Object)name));
        }
        log.info("----------------------------------------------");
    }
}

