/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data.db;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.db.ResettableTempFileInputStream;
import org.junit.Assume;

public class ResettableTempFileInputStreamTest
extends TestCase {
    public void testResetStreamAllowsReadAgain() throws Exception {
        File tmp = this.createTemporaryFileWithContents(new byte[1]);
        ResettableTempFileInputStream in = null;
        try {
            in = new ResettableTempFileInputStream(tmp);
            ResettableTempFileInputStreamTest.assertEquals((int)0, (int)in.read());
            ResettableTempFileInputStreamTest.assertEquals((int)-1, (int)in.read());
            in.reset();
            ResettableTempFileInputStreamTest.assertEquals((int)0, (int)in.read());
            ResettableTempFileInputStreamTest.assertEquals((int)-1, (int)in.read());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    public void testMarkStreamAllowsReadFromMark() throws Exception {
        File tmp = this.createTemporaryFileWithContents(this.createTestByteArray());
        ResettableTempFileInputStream in = null;
        try {
            in = new ResettableTempFileInputStream(tmp);
            Assume.assumeTrue((in.read(new byte[5]) == 5 ? 1 : 0) != 0);
            in.mark(Integer.MAX_VALUE);
            Assume.assumeTrue((in.read(new byte[5]) == 5 ? 1 : 0) != 0);
            in.reset();
            ResettableTempFileInputStreamTest.assertEquals((int)5, (int)in.read());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    private File createTemporaryFileWithContents(byte[] data) throws IOException {
        File tmp = File.createTempFile("test", ".bin");
        FileUtils.writeByteArrayToFile((File)tmp, (byte[])data);
        return tmp;
    }

    private byte[] createTestByteArray() {
        byte[] bytes = new byte[10];
        for (int i = 0; i < 10; ++i) {
            bytes[i] = (byte)i;
        }
        return bytes;
    }
}

