/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.CachingFDS;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.TestFileDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCachingFDS
extends TestFileDataStore {
    protected static final Logger LOG = LoggerFactory.getLogger(TestCachingFDS.class);
    private static final String PENDIND_UPLOAD_FILE = "async-pending-uploads.ser";
    private static final String TO_BE_DELETED_UPLOAD_FILE = "async-tobedeleted-uploads.ser";

    @Override
    protected DataStore createDataStore() throws RepositoryException {
        CachingFDS cacheFDS = new CachingFDS();
        Properties props = this.loadProperties("/fs.properties");
        String pathValue = props.getProperty("fsBackendPath");
        this.fsPath = pathValue != null && !"".equals(pathValue.trim()) ? pathValue + "/cachingFds-" + String.valueOf(this.randomGen.nextInt(100000)) + "-" + String.valueOf(this.randomGen.nextInt(100000)) : this.dataStoreDir + "/cachingFds";
        props.setProperty("fsBackendPath", this.fsPath);
        LOG.info("fsBackendPath [{}] set.", (Object)this.fsPath);
        cacheFDS.setProperties(props);
        cacheFDS.setSecret("12345");
        cacheFDS.setAsyncUploadLimit(0);
        cacheFDS.init(this.dataStoreDir);
        return cacheFDS;
    }

    public void testAsyncUploadCacheCorruption() {
        try {
            this.ds = this.createDataStore();
            File pendingUploads = new File(this.dataStoreDir + "/" + PENDIND_UPLOAD_FILE);
            FileOutputStream fos = new FileOutputStream(pendingUploads);
            IOUtils.write((String)"garbage-data", (OutputStream)fos);
            fos.close();
            File tobeDeletedFile = new File(this.dataStoreDir + "/" + TO_BE_DELETED_UPLOAD_FILE);
            fos = new FileOutputStream(tobeDeletedFile);
            IOUtils.write((String)"garbage-data", (OutputStream)fos);
            fos.close();
            this.ds.close();
            this.doAddRecordTest();
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestCachingFDS.fail((String)e.getMessage());
        }
    }
}

