/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.h2console.ui.webmodule;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.apache.isis.applib.services.inject.ServiceInjector;
import org.apache.isis.applib.value.LocalResourcePath;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.reflection._Reflect;
import org.apache.isis.core.config.datasources.DataSourceIntrospectionService;
import org.apache.isis.core.config.environment.IsisSystemEnvironment;
import org.apache.isis.core.webapp.modules.WebModuleAbstract;
import org.apache.isis.core.webapp.modules.WebModuleContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebServlet;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.test.WebModuleH2Console")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="H2Console")
public class WebModuleH2Console
extends WebModuleAbstract {
    private static final Logger log = LogManager.getLogger(WebModuleH2Console.class);
    private static final String SERVLET_NAME = "H2Console";
    private static final String CONSOLE_PATH = "/db";
    private final LocalResourcePath localResourcePathIfEnabled;
    private final IsisSystemEnvironment isisSystemEnvironment;
    private final boolean applicable;
    private final String name = "H2Console";

    @Inject
    public WebModuleH2Console(DataSourceIntrospectionService datasourceIntrospector, IsisSystemEnvironment isisSystemEnvironment, ServiceInjector serviceInjector) {
        super(serviceInjector);
        this.isisSystemEnvironment = isisSystemEnvironment;
        this.applicable = this.isPrototyping() && this.isH2MemConnectionUsed(datasourceIntrospector);
        this.localResourcePathIfEnabled = this.applicable ? new LocalResourcePath(CONSOLE_PATH) : null;
    }

    public Can<ServletContextListener> init(ServletContext ctx) throws ServletException {
        this.registerServlet(ctx, SERVLET_NAME, H2WebServlet.class).ifPresent(servletReg -> {
            servletReg.addMapping(new String[]{"/db/*"});
            servletReg.setInitParameter("webAllowOthers", "true");
        });
        return Can.empty();
    }

    public boolean isApplicable(WebModuleContext ctx) {
        return this.applicable;
    }

    private boolean isPrototyping() {
        return this.isisSystemEnvironment.getDeploymentType().isPrototyping();
    }

    private boolean isH2MemConnectionUsed(DataSourceIntrospectionService datasourceIntrospector) {
        return datasourceIntrospector.getDataSourceInfos().stream().map(DataSourceIntrospectionService.DataSourceInfo::getJdbcUrl).anyMatch(jdbcUrl -> {
            if (jdbcUrl.contains(":h2:mem:")) {
                log.info("found h2 in-memory data-source: {}", jdbcUrl);
                H2WebServlet.configure(jdbcUrl);
                return true;
            }
            return false;
        });
    }

    public LocalResourcePath getLocalResourcePathIfEnabled() {
        return this.localResourcePathIfEnabled;
    }

    public String getName() {
        return this.name;
    }

    public static class H2WebServlet
    extends WebServlet {
        private static final long serialVersionUID = 1L;
        private static String jdbcUrl;

        public void init() {
            super.init();
            if (_Strings.isEmpty((CharSequence)jdbcUrl)) {
                return;
            }
            DataSourceProperties dataSourceProperties = new DataSourceProperties();
            dataSourceProperties.setUsername("sa");
            dataSourceProperties.setUrl(jdbcUrl);
            ConnectionInfo connectionInfo = new ConnectionInfo(String.format("Generic Spring Datasource|%s|%s|%s", dataSourceProperties.determineDriverClassName(), dataSourceProperties.determineUrl(), dataSourceProperties.determineUsername()));
            H2WebServlet webServlet = this;
            try {
                Field serverField = WebServlet.class.getDeclaredField("server");
                Method updateSettingMethod = WebServer.class.getDeclaredMethod("updateSetting", ConnectionInfo.class);
                WebServer webServer = (WebServer)_Reflect.getFieldOn((Field)serverField, (Object)((Object)webServlet));
                _Reflect.invokeMethodOn((Method)updateSettingMethod, (Object)webServer, (Object[])new Object[]{connectionInfo});
            }
            catch (Exception ex) {
                log.error("Unable to set a custom ConnectionInfo for H2 console", (Throwable)ex);
            }
        }

        public static void configure(String jdbcUrl) {
            H2WebServlet.jdbcUrl = jdbcUrl;
        }
    }
}

