/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.basic;

import java.io.Serializable;
import org.apache.iotdb.tsfile.file.metadata.IMetadata;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public abstract class TimeFilter
extends Filter {
    protected TimeFilter() {
    }

    @Override
    public boolean satisfy(long time, Object value) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean satisfyRow(long time, Object[] values) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean[] satisfyTsBlock(TsBlock tsBlock) {
        boolean[] satisfyInfo = new boolean[tsBlock.getPositionCount()];
        for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
            satisfyInfo[i] = this.timeSatisfy(tsBlock.getTimeByIndex(i));
        }
        return satisfyInfo;
    }

    protected abstract boolean timeSatisfy(long var1);

    @Override
    public boolean canSkip(IMetadata metadata) {
        Statistics<? extends Serializable> timeStatistics = metadata.getTimeStatistics();
        return !this.satisfyStartEndTime(timeStatistics.getStartTime(), timeStatistics.getEndTime());
    }

    @Override
    public boolean allSatisfy(IMetadata metadata) {
        Statistics<? extends Serializable> timeStatistics = metadata.getTimeStatistics();
        return this.containStartEndTime(timeStatistics.getStartTime(), timeStatistics.getEndTime());
    }
}

