/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.relational.tvf;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.udf.builtin.relational.tvf.WindowTVFUtils;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.relational.table.MapTableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionAnalysis;
import org.apache.iotdb.udf.api.relational.table.TableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.iotdb.udf.api.relational.table.argument.Argument;
import org.apache.iotdb.udf.api.relational.table.argument.DescribedSchema;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgument;
import org.apache.iotdb.udf.api.relational.table.argument.TableArgument;
import org.apache.iotdb.udf.api.relational.table.processor.TableFunctionDataProcessor;
import org.apache.iotdb.udf.api.relational.table.specification.ParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.ScalarParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.TableParameterSpecification;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.ColumnBuilder;

public class VariationTableFunction
implements TableFunction {
    private static final String DATA_PARAMETER_NAME = "DATA";
    private static final String COL_PARAMETER_NAME = "COL";
    private static final String DELTA_PARAMETER_NAME = "DELTA";

    public List<ParameterSpecification> getArgumentsSpecifications() {
        return Arrays.asList(TableParameterSpecification.builder().name(DATA_PARAMETER_NAME).passThroughColumns().build(), ScalarParameterSpecification.builder().name(COL_PARAMETER_NAME).type(Type.STRING).build(), ScalarParameterSpecification.builder().name(DELTA_PARAMETER_NAME).type(Type.DOUBLE).build());
    }

    public TableFunctionAnalysis analyze(Map<String, Argument> arguments) throws UDFException {
        TableArgument tableArgument = (TableArgument)arguments.get(DATA_PARAMETER_NAME);
        String expectedFieldName = (String)((ScalarArgument)arguments.get(COL_PARAMETER_NAME)).getValue();
        int requiredIndex = WindowTVFUtils.findColumnIndex(tableArgument, expectedFieldName, (Set<Type>)ImmutableSet.of((Object)Type.INT32, (Object)Type.INT64, (Object)Type.FLOAT, (Object)Type.DOUBLE));
        DescribedSchema properColumnSchema = new DescribedSchema.Builder().addField("window_index", Type.INT64).build();
        MapTableFunctionHandle handle = new MapTableFunctionHandle.Builder().addProperty(DELTA_PARAMETER_NAME, ((ScalarArgument)arguments.get(DELTA_PARAMETER_NAME)).getValue()).build();
        return TableFunctionAnalysis.builder().properColumnSchema(properColumnSchema).requireRecordSnapshot(false).requiredColumns(DATA_PARAMETER_NAME, Collections.singletonList(requiredIndex)).handle((TableFunctionHandle)handle).build();
    }

    public TableFunctionHandle createTableFunctionHandle() {
        return new MapTableFunctionHandle();
    }

    public TableFunctionProcessorProvider getProcessorProvider(TableFunctionHandle tableFunctionHandle) {
        final double delta = (Double)((MapTableFunctionHandle)tableFunctionHandle).getProperty(DELTA_PARAMETER_NAME);
        return new TableFunctionProcessorProvider(){

            public TableFunctionDataProcessor getDataProcessor() {
                return new VariationDataProcessor(delta);
            }
        };
    }

    private static class VariationDataProcessor
    implements TableFunctionDataProcessor {
        private final double gap;
        private long currentStartIndex = -1L;
        private double baseValue = 0.0;
        private long curIndex = 0L;
        private long windowIndex = 0L;

        public VariationDataProcessor(double delta) {
            this.gap = delta;
        }

        public void process(Record input, List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
            double value = input.getDouble(0);
            if (this.currentStartIndex == -1L) {
                this.currentStartIndex = this.curIndex;
                this.baseValue = value;
            } else if (Math.abs(value - this.baseValue) > this.gap) {
                this.outputWindow(properColumnBuilders, passThroughIndexBuilder);
                this.currentStartIndex = this.curIndex;
                this.baseValue = value;
            }
            ++this.curIndex;
        }

        public void finish(List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
            this.outputWindow(properColumnBuilders, passThroughIndexBuilder);
        }

        private void outputWindow(List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
            for (long i = this.currentStartIndex; i < this.curIndex; ++i) {
                properColumnBuilders.get(0).writeLong(this.windowIndex);
                passThroughIndexBuilder.writeLong(i);
            }
            ++this.windowIndex;
        }
    }
}

