/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.iotdb.commons.schema.filter.impl.DataTypeFilter;
import org.apache.iotdb.commons.schema.filter.impl.PathContainsFilter;
import org.apache.iotdb.commons.schema.filter.impl.TagFilter;
import org.apache.iotdb.commons.schema.filter.impl.TemplateFilter;
import org.apache.iotdb.commons.schema.filter.impl.ViewTypeFilter;
import org.apache.iotdb.commons.schema.filter.impl.multichildren.AndFilter;
import org.apache.iotdb.commons.schema.filter.impl.multichildren.OrFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.AttributeFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.IdFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.NotFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.ComparisonFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.InFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.LikeFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.PreciseFilter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class SchemaFilter {
    public static void serialize(SchemaFilter schemaFilter, ByteBuffer byteBuffer) {
        if (schemaFilter == null) {
            ReadWriteIOUtils.write((short)SchemaFilterType.NULL.getCode(), (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((short)schemaFilter.getSchemaFilterType().getCode(), (ByteBuffer)byteBuffer);
            schemaFilter.serialize(byteBuffer);
        }
    }

    public static void serialize(SchemaFilter schemaFilter, DataOutputStream outputStream) throws IOException {
        if (schemaFilter == null) {
            ReadWriteIOUtils.write((short)SchemaFilterType.NULL.getCode(), (OutputStream)outputStream);
        } else {
            ReadWriteIOUtils.write((short)schemaFilter.getSchemaFilterType().getCode(), (OutputStream)outputStream);
            schemaFilter.serialize(outputStream);
        }
    }

    public static SchemaFilter deserialize(ByteBuffer byteBuffer) {
        SchemaFilterType type = SchemaFilterType.getSchemaFilterType(ReadWriteIOUtils.readShort((ByteBuffer)byteBuffer));
        switch (type) {
            case NULL: {
                return null;
            }
            case TAGS_FILTER: {
                return new TagFilter(byteBuffer);
            }
            case PATH_CONTAINS: {
                return new PathContainsFilter(byteBuffer);
            }
            case DATA_TYPE: {
                return new DataTypeFilter(byteBuffer);
            }
            case VIEW_TYPE: {
                return new ViewTypeFilter(byteBuffer);
            }
            case AND: {
                return new AndFilter(byteBuffer);
            }
            case TEMPLATE_FILTER: {
                return new TemplateFilter(byteBuffer);
            }
            case OR: {
                return new OrFilter(byteBuffer);
            }
            case NOT: {
                return new NotFilter(byteBuffer);
            }
            case ID: {
                return new IdFilter(byteBuffer);
            }
            case ATTRIBUTE: {
                return new AttributeFilter(byteBuffer);
            }
            case PRECISE: {
                return new PreciseFilter(byteBuffer);
            }
            case IN: {
                return new InFilter(byteBuffer);
            }
            case LIKE: {
                return new LikeFilter(byteBuffer);
            }
            case COMPARISON: {
                return new ComparisonFilter(byteBuffer);
            }
        }
        throw new IllegalArgumentException("Unsupported schema filter type: " + (Object)((Object)type));
    }

    public static List<SchemaFilter> extract(SchemaFilter schemaFilter, SchemaFilterType filterType) {
        ArrayList<SchemaFilter> res = new ArrayList<SchemaFilter>();
        SchemaFilter.internalExtract(res, schemaFilter, filterType);
        return res;
    }

    private static void internalExtract(List<SchemaFilter> result, SchemaFilter schemaFilter, SchemaFilterType filterType) {
        if (schemaFilter.getSchemaFilterType().equals((Object)filterType)) {
            result.add(schemaFilter);
        }
        if (schemaFilter.getSchemaFilterType().equals((Object)SchemaFilterType.AND)) {
            AndFilter andFilter = (AndFilter)schemaFilter;
            andFilter.getChildren().forEach(child -> SchemaFilter.internalExtract(result, child, filterType));
        }
    }

    public abstract <C> Boolean accept(SchemaFilterVisitor<C> var1, C var2);

    public abstract SchemaFilterType getSchemaFilterType();

    protected abstract void serialize(ByteBuffer var1);

    protected abstract void serialize(DataOutputStream var1) throws IOException;
}

