/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.compressor;

import java.io.IOException;
import org.apache.iotdb.commons.pipe.connector.compressor.PipeCompressor;
import org.apache.tsfile.compress.ICompressor;
import org.apache.tsfile.compress.IUnCompressor;
import org.apache.tsfile.file.metadata.enums.CompressionType;

public class PipeSnappyCompressor
extends PipeCompressor {
    private static final ICompressor COMPRESSOR = ICompressor.getCompressor((CompressionType)CompressionType.SNAPPY);
    private static final IUnCompressor DECOMPRESSOR = IUnCompressor.getUnCompressor((CompressionType)CompressionType.SNAPPY);

    public PipeSnappyCompressor() {
        super(PipeCompressor.PipeCompressionType.SNAPPY);
    }

    @Override
    public byte[] compress(byte[] data) throws IOException {
        return COMPRESSOR.compress(data);
    }

    @Override
    public byte[] decompress(byte[] byteArray) throws IOException {
        return DECOMPRESSOR.uncompress(byteArray);
    }

    @Override
    public byte[] decompress(byte[] byteArray, int decompressedLength) throws IOException {
        byte[] uncompressed = new byte[decompressedLength];
        DECOMPRESSOR.uncompress(byteArray, 0, byteArray.length, uncompressed, 0);
        return uncompressed;
    }
}

