/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.mqtt;

import java.util.Random;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;

public class MQTTClient {
    private static final String DATABASE = "myMqttTest";

    public static void main(String[] args) throws Exception {
        MQTT mqtt = new MQTT();
        mqtt.setHost("127.0.0.1", 1883);
        mqtt.setUserName("root");
        mqtt.setPassword("root");
        mqtt.setConnectAttemptsMax(3L);
        mqtt.setReconnectDelay(10L);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        MQTTClient.linePayloadFormatter(connection);
        connection.disconnect();
    }

    private static void jsonPayloadFormatter(BlockingConnection connection) throws Exception {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            String payload = String.format("{\n\"device\":\"root.sg.d1\",\n\"timestamp\":%d,\n\"measurements\":[\"s1\"],\n\"values\":[%f]\n}", System.currentTimeMillis(), random.nextDouble());
            sb.append(payload).append(",");
            Thread.sleep(1L);
            connection.publish("root.sg.d1.s1", payload.getBytes(), QoS.AT_LEAST_ONCE, false);
        }
        sb.insert(0, "[");
        sb.replace(sb.lastIndexOf(","), sb.length(), "]");
        connection.publish("root.sg.d1.s1", sb.toString().getBytes(), QoS.AT_LEAST_ONCE, false);
    }

    private static void linePayloadFormatter(BlockingConnection connection) throws Exception {
        String payload = "test1,tag1=t1,tag2=t2 attr3=a5,attr4=a4 field1=\"fieldValue1\",field2=1i,field3=1u 1";
        connection.publish("myMqttTest/myTopic", payload.getBytes(), QoS.AT_LEAST_ONCE, false);
        Thread.sleep(10L);
        payload = "test1,tag1=t1,tag2=t2  field4=2,field5=2i32,field6=2f 2";
        connection.publish(DATABASE, payload.getBytes(), QoS.AT_LEAST_ONCE, false);
        Thread.sleep(10L);
        payload = "test1,tag1=t1,tag2=t2  field7=t,field8=T,field9=true 3 \n test1,tag1=t1,tag2=t2  field7=f,field8=F,field9=FALSE 4";
        connection.publish("myMqttTest/myTopic", payload.getBytes(), QoS.AT_LEAST_ONCE, false);
        Thread.sleep(10L);
        payload = "test1,tag1=t1,tag2=t2 attr1=a1,attr2=a2 field1=\"fieldValue1\",field2=1i,field3=1u 4 \n test1,tag1=t1,tag2=t2 field4=2,field5=2i32,field6=2f 5";
        connection.publish("myMqttTest/myTopic", payload.getBytes(), QoS.AT_LEAST_ONCE, false);
        Thread.sleep(10L);
        payload = "# It's a remark\n test1,tag1=t1,tag2=t2 field4=2,field5=2i32,field6=2f 6";
        connection.publish("myMqttTest/myTopic", payload.getBytes(), QoS.AT_LEAST_ONCE, false);
        Thread.sleep(10L);
    }
}

