/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.load;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.load.LoadRuntimeOutOfMemoryException;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.storageengine.load.memory.LoadTsFileMemoryBlock;
import org.apache.iotdb.db.storageengine.load.memory.LoadTsFileMemoryManager;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileTreeSchemaCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileTreeSchemaCache.class);
    private static final int BATCH_FLUSH_TIME_SERIES_NUMBER;
    private static final int MAX_DEVICE_COUNT_TO_USE_DEVICE_TIME_INDEX;
    private static final long ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES;
    private static final long FLUSH_ALIGNED_CACHE_MEMORY_SIZE_IN_BYTES;
    private final LoadTsFileMemoryBlock block = LoadTsFileMemoryManager.getInstance().allocateMemoryBlock(ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES);
    private Map<IDeviceID, Set<MeasurementSchema>> currentBatchDevice2TimeSeriesSchemas = new HashMap<IDeviceID, Set<MeasurementSchema>>();
    private Map<IDeviceID, Boolean> tsFileDevice2IsAligned = new HashMap<IDeviceID, Boolean>();
    private Set<PartialPath> alreadySetDatabases = new HashSet<PartialPath>();
    private Collection<ModEntry> currentModifications = new ArrayList<ModEntry>();
    private ITimeIndex currentTimeIndex;
    private long batchDevice2TimeSeriesSchemasMemoryUsageSizeInBytes = 0L;
    private long tsFileDevice2IsAlignedMemoryUsageSizeInBytes = 0L;
    private long alreadySetDatabasesMemoryUsageSizeInBytes = 0L;
    private long currentModificationsMemoryUsageSizeInBytes = 0L;
    private long currentTimeIndexMemoryUsageSizeInBytes = 0L;
    private int currentBatchTimeSeriesCount = 0;

    public Map<IDeviceID, Set<MeasurementSchema>> getDevice2TimeSeries() {
        return this.currentBatchDevice2TimeSeriesSchemas;
    }

    public boolean getDeviceIsAligned(IDeviceID device) {
        if (!this.tsFileDevice2IsAligned.containsKey(device)) {
            LOGGER.warn("Device {} is not in the tsFileDevice2IsAligned cache {}.", (Object)device, this.tsFileDevice2IsAligned);
        }
        return this.tsFileDevice2IsAligned.get(device);
    }

    public Set<PartialPath> getAlreadySetDatabases() {
        return this.alreadySetDatabases;
    }

    public void addTimeSeries(IDeviceID device, MeasurementSchema measurementSchema) {
        long memoryUsageSizeInBytes = 0L;
        if (!this.currentBatchDevice2TimeSeriesSchemas.containsKey(device)) {
            memoryUsageSizeInBytes += device.ramBytesUsed();
        }
        if (this.currentBatchDevice2TimeSeriesSchemas.computeIfAbsent(device, k -> new HashSet()).add(measurementSchema)) {
            memoryUsageSizeInBytes += (long)measurementSchema.serializedSize();
            ++this.currentBatchTimeSeriesCount;
        }
        if (memoryUsageSizeInBytes > 0L) {
            this.batchDevice2TimeSeriesSchemasMemoryUsageSizeInBytes += memoryUsageSizeInBytes;
            this.block.addMemoryUsage(memoryUsageSizeInBytes);
        }
    }

    public void addIsAlignedCache(IDeviceID device, boolean isAligned, boolean addIfAbsent) {
        long memoryUsageSizeInBytes = 0L;
        if (!this.tsFileDevice2IsAligned.containsKey(device)) {
            memoryUsageSizeInBytes += device.ramBytesUsed();
        }
        if (addIfAbsent ? this.tsFileDevice2IsAligned.putIfAbsent(device, isAligned) == null : this.tsFileDevice2IsAligned.put(device, isAligned) == null) {
            ++memoryUsageSizeInBytes;
        }
        if (memoryUsageSizeInBytes > 0L) {
            this.tsFileDevice2IsAlignedMemoryUsageSizeInBytes += memoryUsageSizeInBytes;
            this.block.addMemoryUsage(memoryUsageSizeInBytes);
        }
    }

    public void setCurrentModificationsAndTimeIndex(TsFileResource resource, TsFileSequenceReader reader) throws IOException {
        this.clearModificationsAndTimeIndex();
        this.currentModifications = ModificationFile.readAllModifications(resource.getTsFile(), true);
        for (ModEntry modification : this.currentModifications) {
            this.currentModificationsMemoryUsageSizeInBytes += (long)modification.serializedSize();
        }
        long newMemorySize = this.currentModificationsMemoryUsageSizeInBytes > ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES / 2L ? this.currentModificationsMemoryUsageSizeInBytes + ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES : ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES;
        this.block.forceResize(newMemorySize);
        this.block.addMemoryUsage(this.currentModificationsMemoryUsageSizeInBytes);
        if (!this.currentModifications.isEmpty() && resource.resourceFileExists()) {
            AtomicInteger deviceCount = new AtomicInteger();
            reader.getAllDevicesIteratorWithIsAligned().forEachRemaining(o -> deviceCount.getAndIncrement());
            if (deviceCount.get() < MAX_DEVICE_COUNT_TO_USE_DEVICE_TIME_INDEX) {
                this.currentTimeIndex = resource.getTimeIndex();
                if (this.currentTimeIndex instanceof FileTimeIndex) {
                    this.currentTimeIndex = resource.buildDeviceTimeIndex();
                }
                this.currentTimeIndexMemoryUsageSizeInBytes = this.currentTimeIndex.calculateRamSize();
                this.block.addMemoryUsage(this.currentTimeIndexMemoryUsageSizeInBytes);
            }
        }
    }

    public boolean isDeviceDeletedByMods(IDeviceID device) throws IllegalPathException {
        return ModificationUtils.isDeviceDeletedByMods(this.currentModifications, this.currentTimeIndex, device);
    }

    public boolean isTimeseriesDeletedByMods(IDeviceID device, TimeseriesMetadata timeseriesMetadata) throws IllegalPathException {
        return ModificationUtils.isTimeseriesDeletedByMods(this.currentModifications, device, timeseriesMetadata.getMeasurementId(), timeseriesMetadata.getStatistics().getStartTime(), timeseriesMetadata.getStatistics().getEndTime());
    }

    public void addAlreadySetDatabase(PartialPath database) {
        long memoryUsageSizeInBytes = 0L;
        if (this.alreadySetDatabases.add(database)) {
            memoryUsageSizeInBytes += (long)PartialPath.estimateSize((PartialPath)database);
        }
        if (memoryUsageSizeInBytes > 0L) {
            this.alreadySetDatabasesMemoryUsageSizeInBytes += memoryUsageSizeInBytes;
            this.block.addMemoryUsage(memoryUsageSizeInBytes);
        }
    }

    public boolean shouldFlushTimeSeries() {
        return !this.block.hasEnoughMemory() || this.currentBatchTimeSeriesCount >= BATCH_FLUSH_TIME_SERIES_NUMBER;
    }

    public boolean shouldFlushAlignedCache() {
        return this.tsFileDevice2IsAlignedMemoryUsageSizeInBytes >= FLUSH_ALIGNED_CACHE_MEMORY_SIZE_IN_BYTES;
    }

    public void clearTimeSeries() {
        this.currentBatchDevice2TimeSeriesSchemas.clear();
        this.block.reduceMemoryUsage(this.batchDevice2TimeSeriesSchemasMemoryUsageSizeInBytes);
        this.batchDevice2TimeSeriesSchemasMemoryUsageSizeInBytes = 0L;
        this.currentBatchTimeSeriesCount = 0;
    }

    public void clearModificationsAndTimeIndex() {
        this.currentModifications.clear();
        this.currentTimeIndex = null;
        this.block.reduceMemoryUsage(this.currentModificationsMemoryUsageSizeInBytes);
        this.block.reduceMemoryUsage(this.currentTimeIndexMemoryUsageSizeInBytes);
        this.currentModificationsMemoryUsageSizeInBytes = 0L;
        this.currentTimeIndexMemoryUsageSizeInBytes = 0L;
    }

    public void clearAlignedCache() {
        this.tsFileDevice2IsAligned.clear();
        this.block.reduceMemoryUsage(this.tsFileDevice2IsAlignedMemoryUsageSizeInBytes);
        this.tsFileDevice2IsAlignedMemoryUsageSizeInBytes = 0L;
    }

    public void clearDeviceIsAlignedCacheIfNecessary() {
        if (!this.shouldFlushAlignedCache()) {
            return;
        }
        long releaseMemoryInBytes = 0L;
        HashSet<IDeviceID> timeSeriesCacheKeySet = new HashSet<IDeviceID>(this.currentBatchDevice2TimeSeriesSchemas.keySet());
        Iterator<Map.Entry<IDeviceID, Boolean>> iterator = this.tsFileDevice2IsAligned.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IDeviceID, Boolean> entry = iterator.next();
            if (timeSeriesCacheKeySet.contains(entry.getKey())) continue;
            releaseMemoryInBytes += entry.getKey().ramBytesUsed() + 1L;
            iterator.remove();
        }
        if (releaseMemoryInBytes > 0L) {
            this.tsFileDevice2IsAlignedMemoryUsageSizeInBytes -= releaseMemoryInBytes;
            this.block.reduceMemoryUsage(releaseMemoryInBytes);
        }
    }

    private void clearDatabasesCache() {
        this.alreadySetDatabases.clear();
        this.block.reduceMemoryUsage(this.alreadySetDatabasesMemoryUsageSizeInBytes);
        this.alreadySetDatabasesMemoryUsageSizeInBytes = 0L;
    }

    public void close() {
        this.clearTimeSeries();
        this.clearModificationsAndTimeIndex();
        this.clearAlignedCache();
        this.clearDatabasesCache();
        this.block.close();
        this.currentBatchDevice2TimeSeriesSchemas = null;
        this.tsFileDevice2IsAligned = null;
        this.alreadySetDatabases = null;
    }

    static {
        IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
        BATCH_FLUSH_TIME_SERIES_NUMBER = CONFIG.getLoadTsFileAnalyzeSchemaBatchFlushTimeSeriesNumber();
        MAX_DEVICE_COUNT_TO_USE_DEVICE_TIME_INDEX = CONFIG.getLoadTsFileMaxDeviceCountToUseDeviceTimeIndex();
        ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES = CONFIG.getLoadTsFileAnalyzeSchemaMemorySizeInBytes() <= 0L ? (long)BATCH_FLUSH_TIME_SERIES_NUMBER << 10 : CONFIG.getLoadTsFileAnalyzeSchemaMemorySizeInBytes();
        FLUSH_ALIGNED_CACHE_MEMORY_SIZE_IN_BYTES = ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES >> 1;
    }
}

