/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl.SizeTieredCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.TsFileResourceCandidate;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.apache.tsfile.file.metadata.IDeviceID;

public class NewSizeTieredCompactionSelector
extends SizeTieredCompactionSelector {
    private List<TsFileResourceCandidate> tsFileResourceCandidateList = new ArrayList<TsFileResourceCandidate>();
    private final long totalFileSizeThreshold;
    private final long totalFileNumUpperBound;
    private final int totalFileNumLowerBound;
    private final long singleFileSizeThreshold;
    private final int maxLevelGap;
    private boolean isActiveTimePartition;

    public NewSizeTieredCompactionSelector(String storageGroupName, String dataRegionId, long timePartition, boolean sequence, TsFileManager tsFileManager, CompactionScheduleContext context) {
        super(storageGroupName, dataRegionId, timePartition, sequence, tsFileManager, context);
        double availableDiskSpaceInByte = MetricService.getInstance().getAutoGauge(SystemMetric.SYS_DISK_AVAILABLE_SPACE.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "system"}).getValue();
        long maxDiskSizeForTempFiles = (long)availableDiskSpaceInByte / (long)config.getCompactionThreadCount();
        maxDiskSizeForTempFiles = maxDiskSizeForTempFiles == 0L ? Long.MAX_VALUE : maxDiskSizeForTempFiles;
        this.maxLevelGap = config.getMaxLevelGapInInnerCompaction();
        this.totalFileNumUpperBound = config.getInnerCompactionTotalFileNumThreshold();
        this.totalFileNumLowerBound = config.getInnerCompactionCandidateFileNum();
        this.totalFileSizeThreshold = Math.min(config.getInnerCompactionTotalFileSizeThresholdInByte(), maxDiskSizeForTempFiles);
        this.singleFileSizeThreshold = Math.min(config.getTargetCompactionFileSize(), maxDiskSizeForTempFiles);
    }

    @Override
    public List<InnerSpaceCompactionTask> selectInnerSpaceTask(List<TsFileResource> tsFileResources) {
        if (tsFileResources.isEmpty()) {
            return Collections.emptyList();
        }
        this.isActiveTimePartition = this.checkIsActiveTimePartition(tsFileResources);
        this.tsFileResourceCandidateList = tsFileResources.stream().map(resource -> new TsFileResourceCandidate((TsFileResource)resource, this.context)).collect(Collectors.toList());
        return super.selectInnerSpaceTask(tsFileResources);
    }

    private boolean checkIsActiveTimePartition(List<TsFileResource> resources) {
        TsFileResource lastResource = resources.get(resources.size() - 1);
        return System.currentTimeMillis() - lastResource.getTsFileID().getTimestamp() < 2L * config.getCompactionScheduleIntervalInMs();
    }

    @Override
    protected List<InnerSpaceCompactionTask> selectTaskBaseOnLevel() throws IOException {
        int maxLevel = this.searchMaxFileLevel();
        for (int currentLevel = 0; currentLevel <= maxLevel; ++currentLevel) {
            List<InnerSpaceCompactionTask> selectedResourceList = this.selectTasksByLevel(currentLevel);
            if (selectedResourceList.isEmpty()) continue;
            return selectedResourceList;
        }
        return Collections.emptyList();
    }

    private List<InnerSpaceCompactionTask> selectTasksByLevel(int level) throws IOException {
        InnerSpaceCompactionTaskSelection levelTaskSelection = new InnerSpaceCompactionTaskSelection(level);
        int startSelectIndex = 0;
        while (startSelectIndex < this.tsFileResourceCandidateList.size()) {
            int idx = 0;
            for (idx = startSelectIndex; idx < this.tsFileResourceCandidateList.size(); ++idx) {
                boolean skipCurrentFile;
                TsFileResourceCandidate currentFile = this.tsFileResourceCandidateList.get(idx);
                long innerCompactionCount = currentFile.resource.getTsFileID().getInnerCompactionCount();
                if (levelTaskSelection.isCurrentTaskEmpty() && innerCompactionCount != (long)level) continue;
                if (!currentFile.isValidCandidate) {
                    levelTaskSelection.endCurrentTaskSelection();
                    break;
                }
                boolean bl = skipCurrentFile = !levelTaskSelection.haveOverlappedDevices(currentFile);
                if (skipCurrentFile) {
                    levelTaskSelection.addSkippedResource(currentFile, idx);
                    continue;
                }
                if (!levelTaskSelection.currentFileSizeSatisfied(currentFile) || !levelTaskSelection.isFileLevelSatisfied(innerCompactionCount)) {
                    levelTaskSelection.endCurrentTaskSelection();
                    break;
                }
                if (levelTaskSelection.isTaskTooLarge(currentFile)) {
                    levelTaskSelection.endCurrentTaskSelection();
                    break;
                }
                levelTaskSelection.addSelectedResource(currentFile, idx);
            }
            levelTaskSelection.endCurrentTaskSelection();
            startSelectIndex = Math.min(idx + 1, levelTaskSelection.getNextTaskStartIndex());
        }
        return levelTaskSelection.getSelectedTaskList();
    }

    private class InnerSpaceCompactionTaskSelection {
        List<InnerSpaceCompactionTask> selectedTaskList = new ArrayList<InnerSpaceCompactionTask>();
        long level;
        List<TsFileResource> currentSelectedResources = new ArrayList<TsFileResource>();
        List<TsFileResource> currentSkippedResources = new ArrayList<TsFileResource>();
        List<TsFileResource> lastContinuousSkippedResources = new ArrayList<TsFileResource>();
        HashSet<IDeviceID> currentSelectedDevices = new HashSet();
        long currentSelectedFileTotalSize = 0L;
        long currentSkippedFileTotalSize = 0L;
        int lastSelectedFileIndex = -1;
        int nextTaskStartIndex = -1;

        private InnerSpaceCompactionTaskSelection(long level) {
            this.level = level;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean haveOverlappedDevices(TsFileResourceCandidate resourceCandidate) throws IOException {
            if (this.currentSelectedDevices.isEmpty()) return true;
            if (!resourceCandidate.getDevices().stream().anyMatch(this.currentSelectedDevices::contains)) return false;
            return true;
        }

        private void addSelectedResource(TsFileResourceCandidate currentFile, int idx) throws IOException {
            this.currentSelectedResources.add(currentFile.resource);
            this.currentSelectedDevices.addAll(currentFile.getDevices());
            this.currentSelectedFileTotalSize += currentFile.resource.getTsFileSize();
            this.lastSelectedFileIndex = idx;
            if (!this.lastContinuousSkippedResources.isEmpty()) {
                this.currentSkippedResources.addAll(this.lastContinuousSkippedResources);
                for (TsFileResource resource : this.lastContinuousSkippedResources) {
                    this.currentSkippedFileTotalSize += resource.getTsFileSize();
                }
                this.lastContinuousSkippedResources.clear();
            }
        }

        private void addSkippedResource(TsFileResourceCandidate currentFile, int idx) {
            this.lastContinuousSkippedResources.add(currentFile.resource);
        }

        private boolean currentFileSizeSatisfied(TsFileResourceCandidate currentFile) {
            return currentFile.resource.getTsFileSize() < NewSizeTieredCompactionSelector.this.totalFileSizeThreshold;
        }

        private boolean isFileLevelSatisfied(long innerCompactionCount) {
            return Math.abs(innerCompactionCount - this.level) <= (long)NewSizeTieredCompactionSelector.this.maxLevelGap;
        }

        private boolean isCurrentTaskEmpty() {
            return this.currentSelectedResources.isEmpty();
        }

        private void reset() {
            this.currentSelectedResources = new ArrayList<TsFileResource>();
            this.currentSkippedResources = new ArrayList<TsFileResource>();
            this.currentSelectedDevices = new HashSet();
            this.lastContinuousSkippedResources = new ArrayList<TsFileResource>();
            this.currentSelectedFileTotalSize = 0L;
            this.currentSkippedFileTotalSize = 0L;
        }

        private boolean isTaskTooLarge(TsFileResourceCandidate currentFile) {
            return currentFile.resource.getTsFileSize() + this.currentSelectedFileTotalSize > NewSizeTieredCompactionSelector.this.totalFileSizeThreshold || (long)(this.currentSelectedResources.size() + 1) > NewSizeTieredCompactionSelector.this.totalFileNumUpperBound;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endCurrentTaskSelection() {
            if (this.isCurrentTaskEmpty()) {
                return;
            }
            try {
                boolean isSatisfied;
                boolean canCompactAllFiles;
                TsFileResource resource;
                long currentFileSize;
                long totalFileSize = this.currentSelectedFileTotalSize + this.currentSkippedFileTotalSize;
                int totalFileNum = this.currentSelectedResources.size() + this.currentSkippedResources.size();
                this.nextTaskStartIndex = this.lastSelectedFileIndex + 1;
                Iterator<TsFileResource> iterator = this.lastContinuousSkippedResources.iterator();
                while (iterator.hasNext() && totalFileSize + (currentFileSize = (resource = iterator.next()).getTsFileSize()) <= NewSizeTieredCompactionSelector.this.singleFileSizeThreshold && (long)(totalFileNum + 1) <= NewSizeTieredCompactionSelector.this.totalFileNumUpperBound && this.isFileLevelSatisfied(resource.getTsFileID().getInnerCompactionCount())) {
                    this.currentSkippedResources.add(resource);
                    totalFileSize += currentFileSize;
                    this.currentSkippedFileTotalSize += currentFileSize;
                    ++totalFileNum;
                    ++this.nextTaskStartIndex;
                }
                if (totalFileNum < 2) {
                    return;
                }
                boolean bl = canCompactAllFiles = totalFileSize <= NewSizeTieredCompactionSelector.this.singleFileSizeThreshold && (long)totalFileNum <= NewSizeTieredCompactionSelector.this.totalFileNumUpperBound;
                if (canCompactAllFiles) {
                    this.currentSelectedResources = Stream.concat(this.currentSelectedResources.stream(), this.currentSkippedResources.stream()).sorted(TsFileResource::compareFileName).collect(Collectors.toList());
                    this.currentSkippedResources.clear();
                    this.currentSelectedFileTotalSize += this.currentSkippedFileTotalSize;
                    this.currentSkippedFileTotalSize = 0L;
                }
                boolean bl2 = isSatisfied = (this.currentSelectedResources.size() >= NewSizeTieredCompactionSelector.this.totalFileNumLowerBound || !NewSizeTieredCompactionSelector.this.isActiveTimePartition || this.currentSelectedFileTotalSize >= NewSizeTieredCompactionSelector.this.singleFileSizeThreshold) && this.currentSelectedResources.size() > 1;
                if (isSatisfied) {
                    InnerSpaceCompactionTask task = this.createInnerSpaceCompactionTask();
                    this.selectedTaskList.add(task);
                }
            }
            finally {
                this.reset();
            }
        }

        private int getNextTaskStartIndex() {
            try {
                if (this.lastSelectedFileIndex == -1) {
                    int n = Integer.MAX_VALUE;
                    return n;
                }
                int n = this.nextTaskStartIndex;
                return n;
            }
            finally {
                this.nextTaskStartIndex = -1;
                this.lastSelectedFileIndex = -1;
            }
        }

        private InnerSpaceCompactionTask createInnerSpaceCompactionTask() {
            return new InnerSpaceCompactionTask(NewSizeTieredCompactionSelector.this.timePartition, NewSizeTieredCompactionSelector.this.tsFileManager, this.currentSelectedResources, this.currentSkippedResources, NewSizeTieredCompactionSelector.this.sequence, NewSizeTieredCompactionSelector.this.createCompactionPerformer(), NewSizeTieredCompactionSelector.this.tsFileManager.getNextCompactionTaskId());
        }

        private List<InnerSpaceCompactionTask> getSelectedTaskList() {
            return this.selectedTaskList;
        }
    }
}

