/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.CheckpointType;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class WritingMetrics
implements IMetricSet {
    private static final WritingMetrics INSTANCE = new WritingMetrics();
    private static final WALManager WAL_MANAGER = WALManager.getInstance();
    public static final String FLUSH_STAGE_SORT = "sort";
    public static final String FLUSH_STAGE_ENCODING = "encoding";
    public static final String FLUSH_STAGE_IO = "io";
    public static final String WRITE_PLAN_INDICES = "write_plan_indices";
    public static final String PENDING_TASK_NUM = "pending_task_num";
    public static final String PENDING_SUB_TASK_NUM = "pending_sub_task_num";
    private Timer flushStageSortTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer flushStageEncodingTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer flushStageIOTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer writePlanIndicesTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    public static final String SORT_TASK = "sort_task";
    public static final String ENCODING_TASK = "encoding_task";
    public static final String IO_TASK = "io_task";
    private Timer sortTaskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer encodingTaskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer ioTaskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    public static final String WAL_NODES_NUM = "wal_nodes_num";
    public static final String USED_RATIO = "used_ratio";
    public static final String SERIALIZED_WAL_BUFFER_SIZE_BYTE = "serialized_wal_buffer_size";
    public static final String WROTE_WAL_BUFFER_SIZE_BYTE = "wrote_wal_buffer_size";
    public static final String WAL_COMPRESS_COST_NS = "wal_compress_cost";
    public static final String WAL_UNCOMPRESS_COST_NS = "wal_uncompress_cost";
    public static final String READ_WAL_BUFFER_SIZE_BYTE = "read_wal_buffer_size";
    public static final String READ_WAL_BUFFER_COST_NS = "read_wal_buffer_cost";
    public static final String WRITE_WAL_BUFFER_COST_NS = "write_wal_buffer_cost";
    public static final String ENTRIES_COUNT = "entries_count";
    public static final String WAL_QUEUE_CURRENT_MEM_COST = "wal_queue_current_mem_cost";
    public static final String WAL_QUEUE_MAX_MEM_COST = "wal_queue_max_mem_cost";
    private Histogram usedRatioHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram entriesCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram serializedWALBufferSizeHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram wroteWALBufferSizeHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram walCompressCostHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram walUncompressCostHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram readWALBufferSizeHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram readWALBufferCostHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram writeWALBufferCostHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Gauge walQueueMaxMemSizeGauge = DoNothingMetricManager.DO_NOTHING_GAUGE;
    public static final String MAKE_CHECKPOINT = "make_checkpoint";
    public static final String SERIALIZE_WAL_ENTRY = "serialize_wal_entry";
    public static final String SERIALIZE_WAL_ENTRY_TOTAL = "serialize_wal_entry_total";
    public static final String SYNC_WAL_BUFFER = "sync_wal_buffer";
    public static final String SYNC = "sync";
    public static final String FSYNC = "fsync";
    private Timer globalMemoryTableInfoTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer createMemoryTableTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer flushMemoryTableTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer serializeWalEntryTotalTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer syncTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer fsyncTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    public static final String MEM_TABLE_SIZE = "mem_table_size";
    public static final String POINTS_NUM = "total_points_num";
    public static final String SERIES_NUM = "series_num";
    public static final String AVG_SERIES_POINT_NUM = "avg_series_points_num";
    public static final String COMPRESSION_RATIO = "compression_ratio";
    public static final String EFFECTIVE_RATIO_INFO = "effective_ratio_info";
    public static final String OLDEST_MEM_TABLE_RAM_WHEN_CAUSE_SNAPSHOT = "oldest_mem_table_ram_when_cause_snapshot";
    public static final String OLDEST_MEM_TABLE_RAM_WHEN_CAUSE_FLUSH = "oldest_mem_table_ram_when_cause_flush";
    public static final String FLUSH_TSFILE_SIZE = "flush_tsfile_size";
    public static final String FLUSH_THRESHOLD = "flush_threshold";
    public static final String REJECT_THRESHOLD = "reject_threshold";
    public static final String TIMED_FLUSH_MEMTABLE_COUNT = "timed_flush_memtable_count";
    public static final String WAL_FLUSH_MEMTABLE_COUNT = "wal_flush_memtable_count";
    public static final String MANUAL_FLUSH_MEMTABLE_COUNT = "manual_flush_memtable_count";
    public static final String MEM_CONTROL_FLUSH_MEMTABLE_COUNT = "mem_control_flush_memtable_count";
    private Gauge flushThreholdGauge = DoNothingMetricManager.DO_NOTHING_GAUGE;
    private Gauge rejectThreholdGauge = DoNothingMetricManager.DO_NOTHING_GAUGE;
    private Timer memtableLiveTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Counter walFlushMemtableCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter timedFlushMemtableCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter manualFlushMemtableCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter memControlFlushMemtableCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Histogram avgPointHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;

    private WritingMetrics() {
    }

    private void bindFlushMetrics(AbstractMetricService metricService) {
        this.flushStageSortTimer = metricService.getOrCreateTimer(Metric.FLUSH_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), FLUSH_STAGE_SORT});
        this.flushStageEncodingTimer = metricService.getOrCreateTimer(Metric.FLUSH_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), FLUSH_STAGE_ENCODING});
        this.flushStageIOTimer = metricService.getOrCreateTimer(Metric.FLUSH_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), FLUSH_STAGE_IO});
        this.writePlanIndicesTimer = metricService.getOrCreateTimer(Metric.FLUSH_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), WRITE_PLAN_INDICES});
        metricService.createAutoGauge(Metric.PENDING_FLUSH_TASK.toString(), MetricLevel.IMPORTANT, (Object)FlushManager.getInstance(), FlushManager::getNumberOfPendingTasks, new String[]{Tag.TYPE.toString(), PENDING_TASK_NUM});
        metricService.createAutoGauge(Metric.PENDING_FLUSH_TASK.toString(), MetricLevel.IMPORTANT, (Object)FlushManager.getInstance(), FlushManager::getNumberOfPendingSubTasks, new String[]{Tag.TYPE.toString(), PENDING_SUB_TASK_NUM});
    }

    private void unbindFlushMetrics(AbstractMetricService metricService) {
        this.flushStageSortTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.flushStageEncodingTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.flushStageIOTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.writePlanIndicesTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(FLUSH_STAGE_SORT, FLUSH_STAGE_ENCODING, FLUSH_STAGE_IO, WRITE_PLAN_INDICES).forEach(stage -> metricService.remove(MetricType.TIMER, Metric.FLUSH_COST.toString(), new String[]{Tag.STAGE.toString(), stage}));
        Arrays.asList(PENDING_TASK_NUM, PENDING_SUB_TASK_NUM).forEach(name -> metricService.remove(MetricType.AUTO_GAUGE, Metric.PENDING_FLUSH_TASK.toString(), new String[]{Tag.NAME.toString(), name}));
    }

    private void bindFlushSubTaskMetrics(AbstractMetricService metricService) {
        this.sortTaskTimer = metricService.getOrCreateTimer(Metric.FLUSH_SUB_TASK_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), SORT_TASK});
        this.encodingTaskTimer = metricService.getOrCreateTimer(Metric.FLUSH_SUB_TASK_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), ENCODING_TASK});
        this.ioTaskTimer = metricService.getOrCreateTimer(Metric.FLUSH_SUB_TASK_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), IO_TASK});
    }

    private void unbindFlushSubTaskMetrics(AbstractMetricService metricService) {
        this.sortTaskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.encodingTaskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.ioTaskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(SORT_TASK, ENCODING_TASK, IO_TASK).forEach(type -> metricService.remove(MetricType.TIMER, Metric.FLUSH_SUB_TASK_COST.toString(), new String[]{Tag.TYPE.toString(), type}));
    }

    private void bindWALMetrics(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.WAL_NODE_NUM.toString(), MetricLevel.IMPORTANT, (Object)WAL_MANAGER, WALManager::getWALNodesNum, new String[]{Tag.NAME.toString(), WAL_NODES_NUM});
        this.usedRatioHistogram = metricService.getOrCreateHistogram(Metric.WAL_BUFFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), USED_RATIO});
        this.entriesCountHistogram = metricService.getOrCreateHistogram(Metric.WAL_BUFFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), ENTRIES_COUNT});
        this.serializedWALBufferSizeHistogram = metricService.getOrCreateHistogram(Metric.WAL_BUFFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), SERIALIZED_WAL_BUFFER_SIZE_BYTE});
        this.wroteWALBufferSizeHistogram = metricService.getOrCreateHistogram(Metric.WAL_BUFFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), WROTE_WAL_BUFFER_SIZE_BYTE});
        this.walCompressCostHistogram = metricService.getOrCreateHistogram(Metric.WAL_BUFFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), WAL_COMPRESS_COST_NS});
        this.walUncompressCostHistogram = metricService.getOrCreateHistogram(Metric.WAL_BUFFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), WAL_UNCOMPRESS_COST_NS});
        this.readWALBufferSizeHistogram = metricService.getOrCreateHistogram(Metric.WAL_BUFFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), READ_WAL_BUFFER_SIZE_BYTE});
        this.readWALBufferCostHistogram = metricService.getOrCreateHistogram(Metric.WAL_BUFFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), READ_WAL_BUFFER_COST_NS});
        this.writeWALBufferCostHistogram = metricService.getOrCreateHistogram(Metric.WAL_BUFFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), WRITE_WAL_BUFFER_COST_NS});
        this.walQueueMaxMemSizeGauge = metricService.getOrCreateGauge(Metric.WAL_QUEUE_MEM_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), WAL_QUEUE_MAX_MEM_COST});
        SystemInfo systemInfo = SystemInfo.getInstance();
        metricService.createAutoGauge(Metric.WAL_QUEUE_MEM_COST.toString(), MetricLevel.IMPORTANT, (Object)systemInfo, s -> s.getWalBufferQueueMemoryBlock().getUsedMemoryInBytes(), new String[]{Tag.NAME.toString(), WAL_QUEUE_CURRENT_MEM_COST});
    }

    private void unbindWALMetrics(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.WAL_NODE_NUM.toString(), new String[]{Tag.NAME.toString(), WAL_NODES_NUM});
        this.usedRatioHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.entriesCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        Arrays.asList(USED_RATIO, ENTRIES_COUNT, SERIALIZED_WAL_BUFFER_SIZE_BYTE, WROTE_WAL_BUFFER_SIZE_BYTE, WAL_COMPRESS_COST_NS, WAL_UNCOMPRESS_COST_NS, READ_WAL_BUFFER_SIZE_BYTE, READ_WAL_BUFFER_COST_NS, WRITE_WAL_BUFFER_COST_NS).forEach(name -> metricService.remove(MetricType.HISTOGRAM, Metric.WAL_BUFFER.toString(), new String[]{Tag.NAME.toString(), name}));
        metricService.remove(MetricType.AUTO_GAUGE, Metric.WAL_QUEUE_MEM_COST.toString(), new String[]{Tag.NAME.toString(), WAL_QUEUE_CURRENT_MEM_COST});
        metricService.remove(MetricType.GAUGE, Metric.WAL_QUEUE_MEM_COST.toString(), new String[]{Tag.NAME.toString(), WAL_QUEUE_MAX_MEM_COST});
    }

    private void bindWALCostMetrics(AbstractMetricService metricService) {
        this.globalMemoryTableInfoTimer = metricService.getOrCreateTimer(Metric.WAL_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), MAKE_CHECKPOINT, Tag.TYPE.toString(), CheckpointType.GLOBAL_MEMORY_TABLE_INFO.toString()});
        this.createMemoryTableTimer = metricService.getOrCreateTimer(Metric.WAL_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), MAKE_CHECKPOINT, Tag.TYPE.toString(), CheckpointType.CREATE_MEMORY_TABLE.toString()});
        this.flushMemoryTableTimer = metricService.getOrCreateTimer(Metric.WAL_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), MAKE_CHECKPOINT, Tag.TYPE.toString(), CheckpointType.FLUSH_MEMORY_TABLE.toString()});
        this.serializeWalEntryTotalTimer = metricService.getOrCreateTimer(Metric.WAL_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), SERIALIZE_WAL_ENTRY, Tag.TYPE.toString(), SERIALIZE_WAL_ENTRY_TOTAL});
        this.syncTimer = metricService.getOrCreateTimer(Metric.WAL_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), SYNC_WAL_BUFFER, Tag.TYPE.toString(), SYNC});
        this.fsyncTimer = metricService.getOrCreateTimer(Metric.WAL_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), SYNC_WAL_BUFFER, Tag.TYPE.toString(), FSYNC});
    }

    private void unbindWALCostMetrics(AbstractMetricService metricService) {
        this.globalMemoryTableInfoTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.createMemoryTableTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.flushMemoryTableTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.serializeWalEntryTotalTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.syncTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.fsyncTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(CheckpointType.GLOBAL_MEMORY_TABLE_INFO.toString(), CheckpointType.CREATE_MEMORY_TABLE.toString(), CheckpointType.FLUSH_MEMORY_TABLE.toString()).forEach(type -> metricService.remove(MetricType.TIMER, Metric.WAL_COST.toString(), new String[]{Tag.STAGE.toString(), MAKE_CHECKPOINT, Tag.TYPE.toString(), type}));
        Collections.singletonList(SERIALIZE_WAL_ENTRY_TOTAL).forEach(type -> metricService.remove(MetricType.TIMER, Metric.WAL_COST.toString(), new String[]{Tag.STAGE.toString(), SERIALIZE_WAL_ENTRY, Tag.TYPE.toString(), type}));
        Arrays.asList(SYNC, FSYNC).forEach(type -> metricService.remove(MetricType.TIMER, Metric.WAL_COST.toString(), new String[]{Tag.STAGE.toString(), SYNC_WAL_BUFFER, Tag.TYPE.toString(), type}));
    }

    public void bindDataRegionMetrics() {
        List<DataRegion> allDataRegions = StorageEngine.getInstance().getAllDataRegions();
        List<DataRegionId> allDataRegionIds = StorageEngine.getInstance().getAllDataRegionIds();
        allDataRegions.forEach(this::createDataRegionMemoryCostMetrics);
        allDataRegionIds.forEach(this::createFlushingMemTableStatusMetrics);
        allDataRegionIds.forEach(this::createActiveMemtableCounterMetrics);
        this.createActiveTimePartitionCounterMetrics();
        this.walFlushMemtableCounter = this.createWalFlushMemTableCounterMetrics();
        this.timedFlushMemtableCounter = this.createTimedFlushMemTableCounterMetrics();
        this.manualFlushMemtableCounter = this.createManualFlushMemTableCounterMetrics();
        this.memControlFlushMemtableCounter = this.createMemControlFlushMemTableCounterMetrics();
        this.flushThreholdGauge = MetricService.getInstance().getOrCreateGauge(Metric.MEMTABLE_THRESHOLD.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), FLUSH_THRESHOLD});
        this.rejectThreholdGauge = MetricService.getInstance().getOrCreateGauge(Metric.MEMTABLE_THRESHOLD.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), REJECT_THRESHOLD});
        this.memtableLiveTimer = MetricService.getInstance().getOrCreateTimer(Metric.MEMTABLE_LIVE_DURATION.toString(), MetricLevel.IMPORTANT, new String[0]);
    }

    public void unbindDataRegionMetrics() {
        List<DataRegionId> allDataRegionIds = StorageEngine.getInstance().getAllDataRegionIds();
        allDataRegionIds.forEach(dataRegionId -> {
            this.removeDataRegionMemoryCostMetrics((DataRegionId)dataRegionId);
            this.removeFlushingMemTableStatusMetrics((DataRegionId)dataRegionId);
            this.removeActiveMemtableCounterMetrics((DataRegionId)dataRegionId);
        });
        this.removeActiveTimePartitionCounterMetrics();
        this.removeTimedFlushMemTableCounterMetrics();
        this.removeWalFlushMemTableCounterMetrics();
        this.removeManualFlushMemTableCounterMetrics();
        this.removeMemControlFlushMemTableCounterMetrics();
        MetricService.getInstance().remove(MetricType.GAUGE, Metric.MEMTABLE_THRESHOLD.toString(), new String[]{Tag.TYPE.toString(), FLUSH_THRESHOLD});
        MetricService.getInstance().remove(MetricType.GAUGE, Metric.MEMTABLE_THRESHOLD.toString(), new String[]{Tag.TYPE.toString(), REJECT_THRESHOLD});
        MetricService.getInstance().remove(MetricType.TIMER, Metric.MEMTABLE_LIVE_DURATION.toString(), new String[0]);
    }

    public void createDataRegionMemoryCostMetrics(DataRegion dataRegion) {
        DataRegionId dataRegionId = new DataRegionId(Integer.parseInt(dataRegion.getDataRegionId()));
        MetricService.getInstance().createAutoGauge(Metric.DATA_REGION_MEM_COST.toString(), MetricLevel.IMPORTANT, (Object)dataRegion, DataRegion::getMemCost, new String[]{Tag.REGION.toString(), dataRegionId.toString()});
    }

    public void removeDataRegionMemoryCostMetrics(DataRegionId dataRegionId) {
        MetricService.getInstance().remove(MetricType.AUTO_GAUGE, Metric.DATA_REGION_MEM_COST.toString(), new String[]{Tag.REGION.toString(), dataRegionId.toString()});
    }

    public void createWALNodeInfoMetrics(String walNodeId) {
        Arrays.asList(EFFECTIVE_RATIO_INFO, OLDEST_MEM_TABLE_RAM_WHEN_CAUSE_SNAPSHOT, OLDEST_MEM_TABLE_RAM_WHEN_CAUSE_FLUSH).forEach(name -> MetricService.getInstance().getOrCreateHistogram(Metric.WAL_NODE_INFO.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), walNodeId}));
    }

    public void removeWALNodeInfoMetrics(String walNodeId) {
        Arrays.asList(EFFECTIVE_RATIO_INFO, OLDEST_MEM_TABLE_RAM_WHEN_CAUSE_SNAPSHOT, OLDEST_MEM_TABLE_RAM_WHEN_CAUSE_FLUSH).forEach(name -> MetricService.getInstance().remove(MetricType.HISTOGRAM, Metric.WAL_NODE_INFO.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), walNodeId}));
    }

    public void createFlushingMemTableStatusMetrics(DataRegionId dataRegionId) {
        Arrays.asList(MEM_TABLE_SIZE, SERIES_NUM, POINTS_NUM, COMPRESSION_RATIO, FLUSH_TSFILE_SIZE).forEach(name -> MetricService.getInstance().getOrCreateHistogram(Metric.FLUSHING_MEM_TABLE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), name, Tag.REGION.toString(), dataRegionId.toString()}));
        this.avgPointHistogram = MetricService.getInstance().getOrCreateHistogram(Metric.FLUSHING_MEM_TABLE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), AVG_SERIES_POINT_NUM, Tag.REGION.toString(), dataRegionId.toString()});
    }

    public Counter createWalFlushMemTableCounterMetrics() {
        return MetricService.getInstance().getOrCreateCounter(Metric.FLUSH_MEMTABLE_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), WAL_FLUSH_MEMTABLE_COUNT});
    }

    public Counter createTimedFlushMemTableCounterMetrics() {
        return MetricService.getInstance().getOrCreateCounter(Metric.FLUSH_MEMTABLE_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TIMED_FLUSH_MEMTABLE_COUNT});
    }

    public Counter createManualFlushMemTableCounterMetrics() {
        return MetricService.getInstance().getOrCreateCounter(Metric.FLUSH_MEMTABLE_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), MANUAL_FLUSH_MEMTABLE_COUNT});
    }

    public Counter createMemControlFlushMemTableCounterMetrics() {
        return MetricService.getInstance().getOrCreateCounter(Metric.FLUSH_MEMTABLE_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), MEM_CONTROL_FLUSH_MEMTABLE_COUNT});
    }

    public void createActiveMemtableCounterMetrics(DataRegionId dataRegionId) {
        MetricService.getInstance().getOrCreateCounter(Metric.ACTIVE_MEMTABLE_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.REGION.toString(), dataRegionId.toString()});
    }

    public void createActiveTimePartitionCounterMetrics() {
        MetricService.getInstance().getOrCreateCounter(Metric.ACTIVE_TIME_PARTITION_COUNT.toString(), MetricLevel.IMPORTANT, new String[0]);
    }

    public void removeTimedFlushMemTableCounterMetrics() {
        MetricService.getInstance().remove(MetricType.COUNTER, Metric.FLUSH_MEMTABLE_COUNT.toString(), new String[]{Tag.TYPE.toString(), TIMED_FLUSH_MEMTABLE_COUNT});
    }

    public void removeWalFlushMemTableCounterMetrics() {
        MetricService.getInstance().remove(MetricType.COUNTER, Metric.FLUSH_MEMTABLE_COUNT.toString(), new String[]{Tag.TYPE.toString(), WAL_FLUSH_MEMTABLE_COUNT});
    }

    public void removeManualFlushMemTableCounterMetrics() {
        MetricService.getInstance().remove(MetricType.COUNTER, Metric.FLUSH_MEMTABLE_COUNT.toString(), new String[]{Tag.TYPE.toString(), MANUAL_FLUSH_MEMTABLE_COUNT});
    }

    public void removeMemControlFlushMemTableCounterMetrics() {
        MetricService.getInstance().remove(MetricType.COUNTER, Metric.FLUSH_MEMTABLE_COUNT.toString(), new String[]{Tag.TYPE.toString(), MEM_CONTROL_FLUSH_MEMTABLE_COUNT});
    }

    public void removeActiveMemtableCounterMetrics(DataRegionId dataRegionId) {
        MetricService.getInstance().remove(MetricType.COUNTER, Metric.ACTIVE_MEMTABLE_COUNT.toString(), new String[]{Tag.REGION.toString(), dataRegionId.toString()});
    }

    public void removeActiveTimePartitionCounterMetrics() {
        MetricService.getInstance().remove(MetricType.COUNTER, Metric.ACTIVE_TIME_PARTITION_COUNT.toString(), new String[0]);
    }

    public void removeFlushingMemTableStatusMetrics(DataRegionId dataRegionId) {
        Arrays.asList(MEM_TABLE_SIZE, SERIES_NUM, POINTS_NUM, AVG_SERIES_POINT_NUM, COMPRESSION_RATIO, FLUSH_TSFILE_SIZE).forEach(name -> MetricService.getInstance().remove(MetricType.HISTOGRAM, Metric.FLUSHING_MEM_TABLE_STATUS.toString(), new String[]{Tag.NAME.toString(), name, Tag.REGION.toString(), dataRegionId.toString()}));
        this.avgPointHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    }

    public void recordWALNodeEffectiveInfoRatio(String walNodeId, double ratio) {
        MetricService.getInstance().histogram((long)(ratio * 100.0), Metric.WAL_NODE_INFO.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), EFFECTIVE_RATIO_INFO, Tag.TYPE.toString(), walNodeId});
    }

    public void recordMemTableRamWhenCauseSnapshot(String walNodeId, long ram) {
        MetricService.getInstance().histogram(ram, Metric.WAL_NODE_INFO.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), OLDEST_MEM_TABLE_RAM_WHEN_CAUSE_SNAPSHOT, Tag.TYPE.toString(), walNodeId});
    }

    public void recordMemTableRamWhenCauseFlush(String walNodeId, long ram) {
        MetricService.getInstance().histogram(ram, Metric.WAL_NODE_INFO.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), OLDEST_MEM_TABLE_RAM_WHEN_CAUSE_FLUSH, Tag.TYPE.toString(), walNodeId});
    }

    public void recordTsFileCompressionRatioOfFlushingMemTable(String dataRegionId, double compressionRatio) {
        MetricService.getInstance().histogram((long)(compressionRatio * 100.0), Metric.FLUSHING_MEM_TABLE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), COMPRESSION_RATIO, Tag.REGION.toString(), new DataRegionId(Integer.parseInt(dataRegionId)).toString()});
    }

    public void recordFlushingMemTableStatus(String storageGroup, long memSize, long seriesNum, long totalPointsNum, long avgSeriesNum) {
        DataRegionId dataRegionId = this.getDataRegionIdFromStorageGroupStr(storageGroup);
        if (dataRegionId == null) {
            return;
        }
        MetricService.getInstance().histogram(memSize, Metric.FLUSHING_MEM_TABLE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), MEM_TABLE_SIZE, Tag.REGION.toString(), dataRegionId.toString()});
        MetricService.getInstance().histogram(seriesNum, Metric.FLUSHING_MEM_TABLE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), SERIES_NUM, Tag.REGION.toString(), dataRegionId.toString()});
        MetricService.getInstance().histogram(totalPointsNum, Metric.FLUSHING_MEM_TABLE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), POINTS_NUM, Tag.REGION.toString(), dataRegionId.toString()});
        this.avgPointHistogram.update(avgSeriesNum);
    }

    public void recordFlushTsFileSize(String storageGroup, long size) {
        DataRegionId dataRegionId = this.getDataRegionIdFromStorageGroupStr(storageGroup);
        if (dataRegionId == null) {
            return;
        }
        MetricService.getInstance().histogram(size, Metric.FLUSHING_MEM_TABLE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), FLUSH_TSFILE_SIZE, Tag.REGION.toString(), dataRegionId.toString()});
    }

    private DataRegionId getDataRegionIdFromStorageGroupStr(String storageGroup) {
        if (Objects.isNull(storageGroup)) {
            return null;
        }
        int idx = storageGroup.lastIndexOf(45);
        if (idx == -1) {
            return null;
        }
        String dataRegionIdStr = storageGroup.substring(idx + 1);
        return new DataRegionId(Integer.parseInt(dataRegionIdStr));
    }

    public void recordFlushCost(String stage, long costTimeInMillis) {
        switch (stage) {
            case "sort": {
                this.flushStageSortTimer.updateMillis(costTimeInMillis);
                break;
            }
            case "encoding": {
                this.flushStageEncodingTimer.updateMillis(costTimeInMillis);
                break;
            }
            case "io": {
                this.flushStageIOTimer.updateMillis(costTimeInMillis);
                break;
            }
            case "write_plan_indices": {
                this.writePlanIndicesTimer.updateMillis(costTimeInMillis);
                break;
            }
        }
    }

    public void recordFlushSubTaskCost(String subTaskType, long costTimeInMillis) {
        switch (subTaskType) {
            case "sort_task": {
                this.sortTaskTimer.updateMillis(costTimeInMillis);
                break;
            }
            case "encoding_task": {
                this.encodingTaskTimer.updateMillis(costTimeInMillis);
                break;
            }
            case "io_task": {
                this.ioTaskTimer.updateMillis(costTimeInMillis);
                break;
            }
        }
    }

    public void recordMakeCheckpointCost(CheckpointType type, long costTimeInNanos) {
        switch (type) {
            case GLOBAL_MEMORY_TABLE_INFO: {
                this.globalMemoryTableInfoTimer.updateNanos(costTimeInNanos);
                break;
            }
            case CREATE_MEMORY_TABLE: {
                this.createMemoryTableTimer.updateNanos(costTimeInNanos);
                break;
            }
            case FLUSH_MEMORY_TABLE: {
                this.flushMemoryTableTimer.updateNanos(costTimeInNanos);
                break;
            }
        }
    }

    public void recordSerializeWALEntryTotalCost(long costTimeInNanos) {
        this.serializeWalEntryTotalTimer.updateNanos(costTimeInNanos);
    }

    public void recordCompressWALBufferCost(long costTimeInNanos) {
        this.walCompressCostHistogram.update(costTimeInNanos);
    }

    public void recordWroteWALBuffer(int serializedSize, int wroteSize, long wroteTimeCostInNanos) {
        this.serializedWALBufferSizeHistogram.update((long)serializedSize);
        this.wroteWALBufferSizeHistogram.update((long)wroteSize);
        this.writeWALBufferCostHistogram.update(wroteTimeCostInNanos);
    }

    public void recordWALUncompressCost(long costTimeInNanos) {
        this.walUncompressCostHistogram.update(costTimeInNanos);
    }

    public void recordWALRead(long size, long costTimeInNanos) {
        this.readWALBufferSizeHistogram.update(size);
        this.readWALBufferCostHistogram.update(costTimeInNanos);
    }

    public void recordSyncWALBufferCost(long costTimeInNanos, boolean forceFlag) {
        if (forceFlag) {
            this.fsyncTimer.updateNanos(costTimeInNanos);
        } else {
            this.syncTimer.updateNanos(costTimeInNanos);
        }
    }

    public void recordWALBufferUsedRatio(double usedRatio) {
        this.usedRatioHistogram.update((long)(usedRatio * 100.0));
    }

    public void recordWALBufferEntriesCount(long count) {
        this.entriesCountHistogram.update(count);
    }

    public void recordWALQueueMaxMemorySize(long size) {
        this.walQueueMaxMemSizeGauge.set(size);
    }

    public void recordFlushThreshold(double flushThreshold) {
        this.flushThreholdGauge.set((long)flushThreshold);
    }

    public void recordRejectThreshold(double rejectThreshold) {
        this.rejectThreholdGauge.set((long)rejectThreshold);
    }

    public void recordMemTableLiveDuration(long durationMillis) {
        this.memtableLiveTimer.updateMillis(durationMillis);
    }

    public void recordTimedFlushMemTableCount(int number) {
        this.timedFlushMemtableCounter.inc((long)number);
    }

    public void recordWalFlushMemTableCount(int number) {
        this.walFlushMemtableCounter.inc((long)number);
    }

    public void recordManualFlushMemTableCount(int number) {
        this.manualFlushMemtableCounter.inc((long)number);
    }

    public void recordMemControlFlushMemTableCount(int number) {
        this.memControlFlushMemtableCounter.inc((long)number);
    }

    public void recordActiveMemTableCount(String dataRegionId, int number) {
        MetricService.getInstance().count((long)number, Metric.ACTIVE_MEMTABLE_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.REGION.toString(), dataRegionId});
    }

    public void recordActiveTimePartitionCount(int number) {
        MetricService.getInstance().count((long)number, Metric.ACTIVE_TIME_PARTITION_COUNT.toString(), MetricLevel.IMPORTANT, new String[0]);
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindFlushMetrics(metricService);
        this.bindFlushSubTaskMetrics(metricService);
        this.bindWALMetrics(metricService);
        this.bindWALCostMetrics(metricService);
        this.bindDataRegionMetrics();
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindFlushMetrics(metricService);
        this.unbindFlushSubTaskMetrics(metricService);
        this.unbindWALMetrics(metricService);
        this.unbindWALCostMetrics(metricService);
        this.unbindDataRegionMetrics();
    }

    public static WritingMetrics getInstance() {
        return INSTANCE;
    }

    public Histogram getAvgPointHistogram() {
        return this.avgPointHistogram;
    }
}

