/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.utils.filter;

import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.iotdb.commons.schema.filter.impl.PathContainsFilter;
import org.apache.iotdb.commons.schema.filter.impl.StringValueFilterVisitor;
import org.apache.iotdb.commons.schema.filter.impl.TemplateFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.AttributeFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.IdFilter;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.tsfile.common.conf.TSFileConfig;

public class DeviceFilterVisitor
extends SchemaFilterVisitor<IDeviceSchemaInfo> {
    public Boolean visitNode(SchemaFilter filter, IDeviceSchemaInfo info) {
        return true;
    }

    public Boolean visitPathContainsFilter(PathContainsFilter pathContainsFilter, IDeviceSchemaInfo info) {
        if (pathContainsFilter.getContainString() == null) {
            return true;
        }
        return info.getFullPath().toLowerCase().contains(pathContainsFilter.getContainString());
    }

    public Boolean visitTemplateFilter(TemplateFilter templateFilter, IDeviceSchemaInfo info) {
        int templateId = info.getTemplateId();
        String filterTemplateName = templateFilter.getTemplateName();
        if (templateId != -1) {
            boolean equalAns = ClusterTemplateManager.getInstance().getTemplate(templateId).getName().equals(filterTemplateName);
            return templateFilter.isEqual() == equalAns;
        }
        if (filterTemplateName == null) {
            return templateFilter.isEqual();
        }
        return false;
    }

    public Boolean visitIdFilter(IdFilter filter, IDeviceSchemaInfo info) {
        String[] nodes = info.getPartialPath().getNodes();
        return filter.getChild().accept((SchemaFilterVisitor)StringValueFilterVisitor.getInstance(), nodes.length > filter.getIndex() + 3 ? nodes[filter.getIndex() + 3] : null);
    }

    public Boolean visitAttributeFilter(AttributeFilter filter, IDeviceSchemaInfo info) {
        return filter.getChild().accept((SchemaFilterVisitor)StringValueFilterVisitor.getInstance(), (Object)info.getAttributeValue(filter.getKey()).getStringValue(TSFileConfig.STRING_CHARSET));
    }
}

