/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.multi;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public abstract class MultiColumnTransformer
extends ColumnTransformer {
    protected final List<ColumnTransformer> columnTransformerList;

    protected MultiColumnTransformer(Type returnType, List<ColumnTransformer> columnTransformerList) {
        super(returnType);
        this.columnTransformerList = columnTransformerList;
        this.checkType();
    }

    @Override
    public void evaluate() {
        for (ColumnTransformer child : this.columnTransformerList) {
            child.tryEvaluate();
        }
        int positionCount = this.columnTransformerList.get(0).getColumnCachePositionCount();
        ColumnBuilder builder = this.returnType.createColumnBuilder(positionCount);
        this.doTransform(this.columnTransformerList.stream().map(ColumnTransformer::getColumn).collect(Collectors.toList()), builder, positionCount);
        this.initializeColumnCache(builder.build());
    }

    @Override
    public void evaluateWithSelection(boolean[] selection) {
        for (ColumnTransformer child : this.columnTransformerList) {
            child.evaluateWithSelection(selection);
        }
        int positionCount = this.columnTransformerList.get(0).getColumnCachePositionCount();
        ColumnBuilder builder = this.returnType.createColumnBuilder(positionCount);
        this.doTransform(this.columnTransformerList.stream().map(ColumnTransformer::getColumn).collect(Collectors.toList()), builder, positionCount, selection);
        this.initializeColumnCache(builder.build());
        for (ColumnTransformer child : this.columnTransformerList) {
            child.clearCache();
        }
    }

    protected abstract void doTransform(List<Column> var1, ColumnBuilder var2, int var3);

    protected abstract void doTransform(List<Column> var1, ColumnBuilder var2, int var3, boolean[] var4);

    public List<ColumnTransformer> getChildren() {
        return this.columnTransformerList;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        for (ColumnTransformer columnTransformer : this.columnTransformerList) {
            columnTransformer.clearCache();
        }
    }
}

