/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.view;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;

public class RenameLogicalViewStatement
extends Statement
implements IConfigStatement {
    private PartialPath oldName;
    private PartialPath newName;

    public RenameLogicalViewStatement() {
        this.statementType = StatementType.RENAME_LOGICAL_VIEW;
    }

    public PartialPath getOldName() {
        return this.oldName;
    }

    public void setOldName(PartialPath oldName) {
        this.oldName = oldName;
    }

    public PartialPath getNewName() {
        return this.newName;
    }

    public void setNewName(PartialPath newName) {
        this.newName = newName;
    }

    public List<PartialPath> getPaths() {
        return Arrays.asList(this.oldName, this.newName);
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        ImmutableList checkedPaths = ImmutableList.of((Object)this.oldName, (Object)this.newName);
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkFullPathListPermission(userName, (List<? extends PartialPath>)checkedPaths, PrivilegeType.WRITE_SCHEMA), (List<? extends PartialPath>)checkedPaths, PrivilegeType.WRITE_SCHEMA);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitRenameLogicalView(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }
}

