/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import java.util.Collections;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GapFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.StreamSortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ValueFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanOptimizer;

public class SortElimination
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, PlanOptimizer.Context context) {
        if (!context.getAnalysis().hasSortNode()) {
            return plan;
        }
        return plan.accept(new Rewriter(), new Context());
    }

    private static class Rewriter
    extends PlanVisitor<PlanNode, Context> {
        private Rewriter() {
        }

        @Override
        public PlanNode visitPlan(PlanNode node, Context context) {
            PlanNode newNode = node.clone();
            for (PlanNode child : node.getChildren()) {
                newNode.addChild(child.accept(this, context));
            }
            return newNode;
        }

        @Override
        public PlanNode visitSort(SortNode node, Context context) {
            Context newContext = new Context();
            PlanNode child = node.getChild().accept(this, newContext);
            context.setHasSeenFill(newContext.hasSeenFill);
            OrderingScheme orderingScheme = node.getOrderingScheme();
            if (!context.hasSeenFill() && newContext.getTotalDeviceEntrySize() == 1 && orderingScheme.getOrderBy().get(0).getName().equals(context.getTimeColumnName())) {
                return child;
            }
            return !context.hasSeenFill() && node.isOrderByAllIdsAndTime() ? child : node.replaceChildren(Collections.singletonList(child));
        }

        @Override
        public PlanNode visitStreamSort(StreamSortNode node, Context context) {
            Context newContext = new Context();
            PlanNode child = node.getChild().accept(this, newContext);
            context.setHasSeenFill(newContext.hasSeenFill);
            return !context.hasSeenFill() && (node.isOrderByAllIdsAndTime() || node.getStreamCompareKeyEndIndex() == node.getOrderingScheme().getOrderBy().size() - 1) ? child : node.replaceChildren(Collections.singletonList(child));
        }

        @Override
        public PlanNode visitDeviceTableScan(DeviceTableScanNode node, Context context) {
            context.addDeviceEntrySize(node.getDeviceEntries().size());
            context.setTimeColumnName(node.getTimeColumn().map(Symbol::getName).orElse(null));
            return node;
        }

        @Override
        public PlanNode visitFill(FillNode node, Context context) {
            PlanNode newNode = node.clone();
            for (PlanNode child : node.getChildren()) {
                newNode.addChild(child.accept(this, context));
            }
            context.setHasSeenFill(!(node instanceof ValueFillNode));
            return newNode;
        }

        @Override
        public PlanNode visitGapFill(GapFillNode node, Context context) {
            PlanNode newNode = node.clone();
            for (PlanNode child : node.getChildren()) {
                newNode.addChild(child.accept(this, context));
            }
            context.setHasSeenFill(true);
            return newNode;
        }
    }

    private static class Context {
        private int totalDeviceEntrySize = 0;
        private boolean hasSeenFill = false;
        private String timeColumnName = null;

        Context() {
        }

        public void addDeviceEntrySize(int deviceEntrySize) {
            this.totalDeviceEntrySize += deviceEntrySize;
        }

        public int getTotalDeviceEntrySize() {
            return this.totalDeviceEntrySize;
        }

        public boolean hasSeenFill() {
            return this.hasSeenFill;
        }

        public void setHasSeenFill(boolean hasSeenFill) {
            this.hasSeenFill = hasSeenFill;
        }

        public String getTimeColumnName() {
            return this.timeColumnName;
        }

        public void setTimeColumnName(String timeColumnName) {
            this.timeColumnName = timeColumnName;
        }
    }
}

