/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.schema;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.impl.multichildren.AndFilter;
import org.apache.iotdb.commons.schema.filter.impl.multichildren.OrFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.AttributeFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.IdFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.NotFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.ComparisonFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.InFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.LikeFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.PreciseFilter;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.PredicatePushIntoScanChecker;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.PredicateVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullIfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StringLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;

public class ConvertSchemaPredicateToFilterVisitor
extends PredicateVisitor<SchemaFilter, Context> {
    @Override
    @Nullable
    protected SchemaFilter visitInPredicate(InPredicate node, Context context) {
        Expression valueList = node.getValueList();
        Preconditions.checkArgument((boolean)(valueList instanceof InListExpression));
        List<Expression> values = ((InListExpression)valueList).getValues();
        for (Expression value2 : values) {
            if (value2 instanceof Literal) continue;
            return null;
        }
        return this.wrapIdOrAttributeFilter((SchemaFilter)new InFilter(values.stream().map(value -> ((StringLiteral)value).getValue()).collect(Collectors.toSet())), ((SymbolReference)node.getValue()).getName(), context);
    }

    @Override
    protected SchemaFilter visitIsNullPredicate(IsNullPredicate node, Context context) {
        return this.wrapIdOrAttributeFilter((SchemaFilter)new PreciseFilter((String)null), ((SymbolReference)node.getValue()).getName(), context);
    }

    @Override
    protected SchemaFilter visitIsNotNullPredicate(IsNotNullPredicate node, Context context) {
        return this.wrapIdOrAttributeFilter((SchemaFilter)new NotFilter((SchemaFilter)new PreciseFilter((String)null)), ((SymbolReference)node.getValue()).getName(), context);
    }

    @Override
    @Nullable
    protected SchemaFilter visitLikePredicate(LikePredicate node, Context context) {
        if (!(node.getValue() instanceof SymbolReference) || !(node.getPattern() instanceof StringLiteral)) {
            return null;
        }
        return this.wrapIdOrAttributeFilter((SchemaFilter)new LikeFilter(((StringLiteral)node.getPattern()).getValue(), node.getEscape().isPresent() ? LikeExpression.getEscapeCharacter(((StringLiteral)node.getEscape().get()).getValue()) : Optional.empty()), ((SymbolReference)node.getValue()).getName(), context);
    }

    @Override
    @Nullable
    protected SchemaFilter visitLogicalExpression(LogicalExpression node, Context context) {
        ArrayList<SchemaFilter> children = new ArrayList<SchemaFilter>();
        for (Expression term : node.getTerms()) {
            SchemaFilter childResult = term.accept(this, context);
            if (Objects.nonNull(childResult)) {
                children.add(childResult);
                continue;
            }
            return null;
        }
        return node.getOperator() == LogicalExpression.Operator.OR ? new OrFilter(children) : new AndFilter(children);
    }

    @Override
    @Nullable
    protected SchemaFilter visitNotExpression(NotExpression node, Context context) {
        SchemaFilter result = node.getValue().accept(this, context);
        return Objects.nonNull(result) ? new NotFilter(result) : null;
    }

    @Override
    @Nullable
    protected SchemaFilter visitComparisonExpression(ComparisonExpression node, Context context) {
        boolean isOrdered;
        String columnName;
        String value;
        if (node.getLeft() instanceof Literal) {
            value = ((StringLiteral)node.getLeft()).getValue();
            Preconditions.checkArgument((boolean)PredicatePushIntoScanChecker.isSymbolReference(node.getRight()));
            columnName = ((SymbolReference)node.getRight()).getName();
            isOrdered = false;
        } else if (node.getRight() instanceof Literal) {
            value = ((StringLiteral)node.getRight()).getValue();
            Preconditions.checkArgument((boolean)PredicatePushIntoScanChecker.isSymbolReference(node.getLeft()));
            columnName = ((SymbolReference)node.getLeft()).getName();
            isOrdered = true;
        } else {
            return null;
        }
        return this.wrapIdOrAttributeFilter((SchemaFilter)(node.getOperator() == ComparisonExpression.Operator.EQUAL ? new PreciseFilter(value) : new ComparisonFilter(this.convertExpressionOperator2SchemaOperator(node.getOperator(), isOrdered), value)), columnName, context);
    }

    private ComparisonFilter.Operator convertExpressionOperator2SchemaOperator(ComparisonExpression.Operator operator, boolean isOrdered) {
        switch (operator) {
            case NOT_EQUAL: {
                return ComparisonFilter.Operator.NOT_EQUAL;
            }
            case LESS_THAN: {
                return isOrdered ? ComparisonFilter.Operator.LESS_THAN : ComparisonFilter.Operator.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return isOrdered ? ComparisonFilter.Operator.LESS_THAN_OR_EQUAL : ComparisonFilter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return isOrdered ? ComparisonFilter.Operator.GREATER_THAN : ComparisonFilter.Operator.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return isOrdered ? ComparisonFilter.Operator.GREATER_THAN_OR_EQUAL : ComparisonFilter.Operator.LESS_THAN_OR_EQUAL;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator " + (Object)((Object)operator));
    }

    @Override
    protected SchemaFilter visitSimpleCaseExpression(SimpleCaseExpression node, Context context) {
        return (SchemaFilter)this.visitExpression(node, context);
    }

    @Override
    protected SchemaFilter visitSearchedCaseExpression(SearchedCaseExpression node, Context context) {
        return (SchemaFilter)this.visitExpression(node, context);
    }

    @Override
    protected SchemaFilter visitIfExpression(IfExpression node, Context context) {
        return (SchemaFilter)this.visitExpression(node, context);
    }

    @Override
    protected SchemaFilter visitNullIfExpression(NullIfExpression node, Context context) {
        return (SchemaFilter)this.visitExpression(node, context);
    }

    @Override
    protected SchemaFilter visitBetweenPredicate(BetweenPredicate node, Context context) {
        return (SchemaFilter)this.visitExpression(node, context);
    }

    private SchemaFilter wrapIdOrAttributeFilter(SchemaFilter filter, String columnName, Context context) {
        return context.table.getColumnSchema(columnName).getColumnCategory().equals((Object)TsTableColumnCategory.TAG) ? new IdFilter(filter, ((Integer)context.idColumnIndexMap.get(columnName)).intValue()) : new AttributeFilter(filter, columnName);
    }

    public static class Context {
        private final TsTable table;
        private final Map<String, Integer> idColumnIndexMap;

        public Context(TsTable table) {
            this.table = table;
            this.idColumnIndexMap = this.getIdColumnIndex(table);
        }

        private Map<String, Integer> getIdColumnIndex(TsTable table) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            List columnSchemaList = table.getColumnList();
            int idIndex = 0;
            for (TsTableColumnSchema columnSchema : columnSchemaList) {
                if (!columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.TAG)) continue;
                map.put(columnSchema.getColumnName(), idIndex);
                ++idIndex;
            }
            return map;
        }
    }
}

