/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ResolvedField;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExistsPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuantifiedComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubqueryExpression;
import org.apache.tsfile.read.common.type.Type;

public class ExpressionAnalysis {
    private final Map<NodeRef<Expression>, Type> expressionTypes;
    private final Map<NodeRef<Expression>, ResolvedField> columnReferences;
    private final Set<NodeRef<InPredicate>> subqueryInPredicates;
    private final Set<NodeRef<SubqueryExpression>> subqueries;
    private final Set<NodeRef<ExistsPredicate>> existsSubqueries;
    private final Set<NodeRef<QuantifiedComparisonExpression>> quantifiedComparisons;

    public ExpressionAnalysis(Map<NodeRef<Expression>, Type> expressionTypes, Set<NodeRef<InPredicate>> subqueryInPredicates, Set<NodeRef<SubqueryExpression>> subqueries, Set<NodeRef<ExistsPredicate>> existsSubqueries, Map<NodeRef<Expression>, ResolvedField> columnReferences, Set<NodeRef<QuantifiedComparisonExpression>> quantifiedComparisons) {
        this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
        this.columnReferences = ImmutableMap.copyOf(Objects.requireNonNull(columnReferences, "columnReferences is null"));
        this.subqueryInPredicates = ImmutableSet.copyOf((Collection)Objects.requireNonNull(subqueryInPredicates, "subqueryInPredicates is null"));
        this.subqueries = ImmutableSet.copyOf((Collection)Objects.requireNonNull(subqueries, "subqueries is null"));
        this.existsSubqueries = ImmutableSet.copyOf((Collection)Objects.requireNonNull(existsSubqueries, "existsSubqueries is null"));
        this.quantifiedComparisons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(quantifiedComparisons, "quantifiedComparisons is null"));
    }

    public Type getType(Expression expression) {
        return this.expressionTypes.get(NodeRef.of(expression));
    }

    public Map<NodeRef<Expression>, Type> getExpressionTypes() {
        return this.expressionTypes;
    }

    public boolean isColumnReference(Expression node) {
        return this.columnReferences.containsKey(NodeRef.of(node));
    }

    public Set<NodeRef<InPredicate>> getSubqueryInPredicates() {
        return this.subqueryInPredicates;
    }

    public Set<NodeRef<SubqueryExpression>> getSubqueries() {
        return this.subqueries;
    }

    public Set<NodeRef<ExistsPredicate>> getExistsSubqueries() {
        return this.existsSubqueries;
    }

    public Set<NodeRef<QuantifiedComparisonExpression>> getQuantifiedComparisons() {
        return this.quantifiedComparisons;
    }
}

