/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.function.WindowFunction;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.PartitionExecutor;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame.FrameInfo;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.RowComparator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TableWindowOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TableWindowOperator.class);
    private final OperatorContext operatorContext;
    private final Operator inputOperator;
    private final List<TSDataType> inputDataTypes;
    private final List<Integer> outputChannels;
    private final TsBlockBuilder tsBlockBuilder;
    private final MemoryReservationManager memoryReservationManager;
    private final List<WindowFunction> windowFunctions;
    private final List<FrameInfo> frameInfoList;
    private final List<Integer> partitionChannels;
    private final RowComparator partitionComparator;
    private final List<TsBlock> cachedTsBlocks;
    private int startIndexInFirstBlock;
    private final List<Integer> sortChannels;
    private LinkedList<PartitionExecutor> cachedPartitionExecutors;
    private long totalMemorySize;
    private long maxUsedMemory;
    private final long maxRuntime;

    public TableWindowOperator(OperatorContext operatorContext, Operator inputOperator, List<TSDataType> inputDataTypes, List<TSDataType> outputDataTypes, List<Integer> outputChannels, List<WindowFunction> windowFunctions, List<FrameInfo> frameInfoList, List<Integer> partitionChannels, List<Integer> sortChannels) {
        this.operatorContext = operatorContext;
        this.inputOperator = inputOperator;
        this.inputDataTypes = ImmutableList.copyOf(inputDataTypes);
        this.outputChannels = ImmutableList.copyOf(outputChannels);
        this.tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        this.windowFunctions = windowFunctions;
        this.frameInfoList = frameInfoList;
        this.partitionChannels = ImmutableList.copyOf(partitionChannels);
        ArrayList<TSDataType> partitionDataTypes = new ArrayList<TSDataType>();
        for (Integer channel : partitionChannels) {
            partitionDataTypes.add(inputDataTypes.get(channel));
        }
        this.partitionComparator = new RowComparator(partitionDataTypes);
        this.sortChannels = ImmutableList.copyOf(sortChannels);
        this.cachedPartitionExecutors = new LinkedList();
        this.cachedTsBlocks = new ArrayList<TsBlock>();
        this.startIndexInFirstBlock = -1;
        this.maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        this.totalMemorySize = 0L;
        this.maxUsedMemory = 0L;
        this.memoryReservationManager = operatorContext.getDriverContext().getFragmentInstanceContext().getMemoryReservationContext();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock tsBlock;
        long startTime = System.nanoTime();
        if (!this.cachedPartitionExecutors.isEmpty() && (tsBlock = this.transform(startTime)) != null) {
            return tsBlock;
        }
        if (this.inputOperator.hasNextWithTimer()) {
            TsBlock preSortedBlock = this.inputOperator.nextWithTimer();
            if (preSortedBlock == null || preSortedBlock.isEmpty()) {
                return null;
            }
            this.cachedPartitionExecutors = this.partition(preSortedBlock);
            if (this.cachedPartitionExecutors.isEmpty()) {
                return null;
            }
            return this.transform(startTime);
        }
        if (!this.cachedTsBlocks.isEmpty()) {
            TsBlock lastTsBlock = this.cachedTsBlocks.get(this.cachedTsBlocks.size() - 1);
            int endIndexOfLastTsBlock = lastTsBlock.getPositionCount();
            PartitionExecutor partitionExecutor = new PartitionExecutor(this.cachedTsBlocks, this.inputDataTypes, this.startIndexInFirstBlock, endIndexOfLastTsBlock, this.outputChannels, this.windowFunctions, this.frameInfoList, this.sortChannels);
            this.cachedPartitionExecutors.addLast(partitionExecutor);
            this.cachedTsBlocks.clear();
            this.releaseAllCachedTsBlockMemory();
            TsBlock tsBlock2 = this.transform(startTime);
            if (tsBlock2 == null) {
                tsBlock2 = this.tsBlockBuilder.build((Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, this.tsBlockBuilder.getPositionCount()));
                this.tsBlockBuilder.reset();
            }
            return tsBlock2;
        }
        if (!this.tsBlockBuilder.isEmpty()) {
            return this.getTsBlockFromTsBlockBuilder();
        }
        return null;
    }

    private LinkedList<PartitionExecutor> partition(TsBlock tsBlock) {
        LinkedList<PartitionExecutor> partitionExecutors = new LinkedList<PartitionExecutor>();
        int partitionStartInCurrentBlock = 0;
        int partitionEndInCurrentBlock = partitionStartInCurrentBlock + 1;
        List<Column> partitionColumns = this.extractPartitionColumns(tsBlock);
        if (!this.cachedTsBlocks.isEmpty()) {
            TsBlock lastTsBlock = this.cachedTsBlocks.get(this.cachedTsBlocks.size() - 1);
            int endIndexOfLastTsBlock = lastTsBlock.getPositionCount();
            List<Column> lastPartitionColumns = this.extractPartitionColumns(lastTsBlock);
            if (!this.partitionComparator.equal(partitionColumns, 0, lastPartitionColumns, endIndexOfLastTsBlock - 1)) {
                PartitionExecutor partitionExecutor = new PartitionExecutor(this.cachedTsBlocks, this.inputDataTypes, this.startIndexInFirstBlock, endIndexOfLastTsBlock, this.outputChannels, this.windowFunctions, this.frameInfoList, this.sortChannels);
                partitionExecutors.addLast(partitionExecutor);
                this.cachedTsBlocks.clear();
                this.releaseAllCachedTsBlockMemory();
                this.startIndexInFirstBlock = -1;
            }
        }
        int count = tsBlock.getPositionCount();
        while (count == 1 || partitionEndInCurrentBlock < count) {
            while (partitionEndInCurrentBlock < count && this.partitionComparator.equalColumns(partitionColumns, partitionStartInCurrentBlock, partitionEndInCurrentBlock)) {
                ++partitionEndInCurrentBlock;
            }
            if (partitionEndInCurrentBlock != count) {
                PartitionExecutor partitionExecutor;
                if (partitionStartInCurrentBlock != 0 || this.startIndexInFirstBlock == -1) {
                    partitionExecutor = new PartitionExecutor(Collections.singletonList(tsBlock), this.inputDataTypes, partitionStartInCurrentBlock, partitionEndInCurrentBlock, this.outputChannels, this.windowFunctions, this.frameInfoList, this.sortChannels);
                } else {
                    this.reserveOneTsBlockMemory(tsBlock);
                    this.cachedTsBlocks.add(tsBlock);
                    partitionExecutor = new PartitionExecutor(this.cachedTsBlocks, this.inputDataTypes, this.startIndexInFirstBlock, partitionEndInCurrentBlock, this.outputChannels, this.windowFunctions, this.frameInfoList, this.sortChannels);
                    this.cachedTsBlocks.clear();
                    this.releaseAllCachedTsBlockMemory();
                }
                partitionExecutors.addLast(partitionExecutor);
                partitionStartInCurrentBlock = partitionEndInCurrentBlock;
                partitionEndInCurrentBlock = partitionStartInCurrentBlock + 1;
                continue;
            }
            if (this.startIndexInFirstBlock == -1) {
                this.startIndexInFirstBlock = partitionStartInCurrentBlock;
            }
            this.reserveOneTsBlockMemory(tsBlock);
            this.cachedTsBlocks.add(tsBlock);
            break;
        }
        return partitionExecutors;
    }

    private TsBlock transform(long startTime) {
        while (!this.cachedPartitionExecutors.isEmpty()) {
            PartitionExecutor partitionExecutor = this.cachedPartitionExecutors.getFirst();
            while (System.nanoTime() - startTime < this.maxRuntime && !this.tsBlockBuilder.isFull() && partitionExecutor.hasNext()) {
                partitionExecutor.processNextRow(this.tsBlockBuilder);
            }
            if (!partitionExecutor.hasNext()) {
                this.cachedPartitionExecutors.removeFirst();
            }
            if (System.nanoTime() - startTime < this.maxRuntime && !this.tsBlockBuilder.isFull()) continue;
            return this.getTsBlockFromTsBlockBuilder();
        }
        return null;
    }

    private List<Column> extractPartitionColumns(TsBlock tsBlock) {
        ArrayList<Column> partitionColumns = new ArrayList<Column>(this.partitionChannels.size());
        for (int channel : this.partitionChannels) {
            Column partitionColumn = tsBlock.getColumn(channel);
            partitionColumns.add(partitionColumn);
        }
        return partitionColumns;
    }

    private TsBlock getTsBlockFromTsBlockBuilder() {
        TsBlock result = this.tsBlockBuilder.build((Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, this.tsBlockBuilder.getPositionCount()));
        this.tsBlockBuilder.reset();
        return result;
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.cachedPartitionExecutors.isEmpty() || this.inputOperator.hasNext() || !this.cachedTsBlocks.isEmpty() || !this.tsBlockBuilder.isEmpty();
    }

    @Override
    public void close() throws Exception {
        this.inputOperator.close();
        if (this.totalMemorySize != 0L) {
            this.memoryReservationManager.releaseMemoryCumulatively(this.totalMemorySize);
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    private void reserveOneTsBlockMemory(TsBlock tsBlock) {
        long reserved = tsBlock.getTotalInstanceSize();
        this.memoryReservationManager.reserveMemoryCumulatively(reserved);
        this.totalMemorySize += reserved;
        this.maxUsedMemory = Math.max(this.maxUsedMemory, this.totalMemorySize);
        this.operatorContext.recordSpecifiedInfo("MaxReservedMemory", Long.toString(this.maxUsedMemory));
    }

    private void releaseAllCachedTsBlockMemory() {
        long released = this.cachedTsBlocks.stream().mapToInt(TsBlock::getTotalInstanceSize).sum();
        this.memoryReservationManager.releaseMemoryCumulatively(released);
        this.totalMemorySize -= released;
        this.operatorContext.recordSpecifiedInfo("MaxReservedMemory", Long.toString(this.maxUsedMemory));
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemoryFromInput = this.inputOperator.calculateMaxPeekMemoryWithCounter();
        long maxPeekMemoryFromCurrent = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
        return Math.max(maxPeekMemoryFromInput, maxPeekMemoryFromCurrent) + this.inputOperator.calculateRetainedSizeAfterCallingNext();
    }

    @Override
    public long calculateMaxReturnSize() {
        return TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.inputOperator.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.inputOperator) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + this.tsBlockBuilder.getRetainedSizeInBytes();
    }
}

