/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.wal.hardlink;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.pipe.resource.wal.PipeWALResource;
import org.apache.iotdb.db.pipe.resource.wal.PipeWALResourceManager;
import org.apache.iotdb.db.pipe.resource.wal.hardlink.PipeWALHardlinkResource;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryHandler;

public class PipeWALHardlinkResourceManager
extends PipeWALResourceManager {
    private final Map<String, Integer> hardlinkToReferenceMap = new HashMap<String, Integer>();

    @Override
    protected void pinInternal(long memTableId, WALEntryHandler walEntryHandler) {
        this.memtableIdToPipeWALResourceMap.computeIfAbsent(memTableId, id -> new PipeWALHardlinkResource(walEntryHandler, this)).pin();
    }

    @Override
    protected void unpinInternal(long memTableId, WALEntryHandler walEntryHandler) {
        ((PipeWALResource)this.memtableIdToPipeWALResourceMap.get(memTableId)).unpin();
    }

    public synchronized File increaseFileReference(File file) throws IOException {
        if (this.increaseReferenceIfExists(file.getPath())) {
            return file;
        }
        File hardlink = PipeWALHardlinkResourceManager.getHardlinkInPipeWALDir(file);
        if (this.increaseReferenceIfExists(hardlink.getPath())) {
            return hardlink;
        }
        this.hardlinkToReferenceMap.put(hardlink.getPath(), 1);
        return FileUtils.createHardLink((File)file, (File)hardlink);
    }

    private boolean increaseReferenceIfExists(String path) {
        this.hardlinkToReferenceMap.computeIfPresent(path, (k, v) -> v + 1);
        return this.hardlinkToReferenceMap.containsKey(path);
    }

    private static File getHardlinkInPipeWALDir(File file) throws IOException {
        try {
            return new File(PipeWALHardlinkResourceManager.getPipeWALDirPath(file), PipeWALHardlinkResourceManager.getRelativeFilePath(file));
        }
        catch (Exception e) {
            throw new IOException(String.format("failed to get hardlink in pipe dir for file %s, it is not a wal", file.getPath()), e);
        }
    }

    private static String getPipeWALDirPath(File file) throws IOException {
        while (!file.getName().equals("wal")) {
            file = file.getParentFile();
        }
        return file.getParentFile().getCanonicalPath() + File.separator + "data" + File.separator + PipeConfig.getInstance().getPipeHardlinkBaseDirName() + File.separator + PipeConfig.getInstance().getPipeHardlinkWALDirName();
    }

    private static String getRelativeFilePath(File file) {
        StringBuilder builder = new StringBuilder(file.getName());
        while (!file.getParentFile().getName().equals("wal")) {
            file = file.getParentFile();
            builder = new StringBuilder(file.getName()).append("-").append((CharSequence)builder);
        }
        return builder.toString();
    }

    public synchronized void decreaseFileReference(File hardlink) throws IOException {
        Integer updatedReference = this.hardlinkToReferenceMap.computeIfPresent(hardlink.getPath(), (file, reference) -> reference - 1);
        if (updatedReference != null && updatedReference == 0) {
            Files.deleteIfExists(hardlink.toPath());
            this.hardlinkToReferenceMap.remove(hardlink.getPath());
        }
    }

    @TestOnly
    public synchronized int getFileReferenceCount(File hardlink) {
        return this.hardlinkToReferenceMap.getOrDefault(hardlink.getPath(), 0);
    }
}

