/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.util.sorter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.pipe.connector.util.sorter.PipeTabletEventSorter;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class PipeTableModelTabletEventSorter {
    private final Tablet tablet;
    private Integer[] index;
    private boolean isUnSorted = false;
    private boolean hasDuplicates = false;
    private int deduplicatedSize;
    private int initIndexSize;

    public PipeTableModelTabletEventSorter(Tablet tablet) {
        this.tablet = tablet;
        this.deduplicatedSize = tablet == null ? 0 : tablet.getRowSize();
    }

    public void sortAndDeduplicateByDevIdTimestamp() {
        if (this.tablet == null || this.tablet.getRowSize() < 1) {
            return;
        }
        HashMap<IDeviceID, List> deviceIDToIndexMap = new HashMap<IDeviceID, List>();
        long[] timestamps = this.tablet.getTimestamps();
        IDeviceID lastDevice = this.tablet.getDeviceID(0);
        long previousTimestamp = this.tablet.getTimestamp(0);
        int lasIndex = 0;
        int size = this.tablet.getRowSize();
        for (int i = 1; i < size; ++i) {
            List list;
            IDeviceID deviceID = this.tablet.getDeviceID(i);
            long currentTimestamp = timestamps[i];
            int deviceComparison = deviceID.compareTo((Object)lastDevice);
            if (deviceComparison == 0) {
                if (previousTimestamp == currentTimestamp) {
                    this.hasDuplicates = true;
                    continue;
                }
                if (previousTimestamp > currentTimestamp) {
                    this.isUnSorted = true;
                }
                previousTimestamp = currentTimestamp;
                continue;
            }
            if (deviceComparison < 0) {
                this.isUnSorted = true;
            }
            if (!(list = deviceIDToIndexMap.computeIfAbsent(lastDevice, k -> new ArrayList())).isEmpty()) {
                this.isUnSorted = true;
            }
            list.add(new Pair((Object)lasIndex, (Object)i));
            lastDevice = deviceID;
            lasIndex = i;
            previousTimestamp = currentTimestamp;
        }
        List list = deviceIDToIndexMap.computeIfAbsent(lastDevice, k -> new ArrayList());
        if (!list.isEmpty()) {
            this.isUnSorted = true;
        }
        list.add(new Pair((Object)lasIndex, (Object)this.tablet.getRowSize()));
        if (!this.isUnSorted && !this.hasDuplicates) {
            return;
        }
        this.initIndexSize = 0;
        this.deduplicatedSize = 0;
        this.index = new Integer[this.tablet.getRowSize()];
        deviceIDToIndexMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            int start = this.initIndexSize;
            int i = this.initIndexSize;
            for (Pair pair : (List)entry.getValue()) {
                for (int j = ((Integer)pair.left).intValue(); j < (Integer)pair.right; ++j) {
                    this.index[i++] = j;
                }
            }
            if (this.isUnSorted) {
                this.sortTimestamps(start, i);
                this.deduplicateTimestamps(start, i);
                this.initIndexSize = i;
                return;
            }
            if (this.hasDuplicates) {
                this.deduplicateTimestamps(start, i);
            }
            this.initIndexSize = i;
        });
        this.sortAndDeduplicateValuesAndBitMaps();
    }

    private void sortAndDeduplicateValuesAndBitMaps() {
        int columnIndex = 0;
        this.tablet.setTimestamps((long[])PipeTabletEventSorter.reorderValueList(this.deduplicatedSize, this.tablet.getTimestamps(), TSDataType.TIMESTAMP, this.index));
        int size = this.tablet.getSchemas().size();
        for (int i = 0; i < size; ++i) {
            IMeasurementSchema schema = (IMeasurementSchema)this.tablet.getSchemas().get(i);
            if (schema == null) continue;
            this.tablet.getValues()[columnIndex] = PipeTabletEventSorter.reorderValueList(this.deduplicatedSize, this.tablet.getValues()[columnIndex], schema.getType(), this.index);
            if (this.tablet.getBitMaps() != null && this.tablet.getBitMaps()[columnIndex] != null) {
                this.tablet.getBitMaps()[columnIndex] = PipeTabletEventSorter.reorderBitMap(this.deduplicatedSize, this.tablet.getBitMaps()[columnIndex], this.index);
            }
            ++columnIndex;
        }
        this.tablet.setRowSize(this.deduplicatedSize);
    }

    private void sortTimestamps(int startIndex, int endIndex) {
        Arrays.sort(this.index, startIndex, endIndex, Comparator.comparingLong(arg_0 -> ((Tablet)this.tablet).getTimestamp(arg_0)));
    }

    private void deduplicateTimestamps(int startIndex, int endIndex) {
        long[] timestamps = this.tablet.getTimestamps();
        long lastTime = timestamps[this.index[startIndex]];
        this.index[this.deduplicatedSize++] = this.index[startIndex];
        for (int i = startIndex + 1; i < endIndex; ++i) {
            if (lastTime == (lastTime = timestamps[this.index[i]])) continue;
            this.index[this.deduplicatedSize++] = this.index[i];
        }
    }

    public void sortAndDeduplicateByTimestampIfNecessary() {
        int i;
        if (this.tablet == null || this.tablet.getRowSize() == 0) {
            return;
        }
        long[] timestamps = this.tablet.getTimestamps();
        int size = this.tablet.getRowSize();
        for (i = 1; i < size; ++i) {
            long currentTimestamp = timestamps[i];
            long previousTimestamp = timestamps[i - 1];
            if (currentTimestamp < previousTimestamp) {
                this.isUnSorted = true;
                break;
            }
            if (currentTimestamp != previousTimestamp) continue;
            this.hasDuplicates = true;
        }
        if (!this.isUnSorted && !this.hasDuplicates) {
            return;
        }
        this.index = new Integer[this.tablet.getRowSize()];
        size = this.tablet.getRowSize();
        for (i = 0; i < size; ++i) {
            this.index[i] = i;
        }
        if (this.isUnSorted) {
            this.sortTimestamps();
            this.deduplicateTimestamps();
            this.hasDuplicates = false;
        }
        if (this.hasDuplicates) {
            this.deduplicateTimestamps();
        }
        this.sortAndDeduplicateValuesAndBitMapsIgnoreTimestamp();
    }

    private void sortTimestamps() {
        Arrays.sort(this.index, Comparator.comparingLong(arg_0 -> ((Tablet)this.tablet).getTimestamp(arg_0)));
        Arrays.sort(this.tablet.getTimestamps(), 0, this.tablet.getRowSize());
    }

    private void deduplicateTimestamps() {
        this.deduplicatedSize = 1;
        long[] timestamps = this.tablet.getTimestamps();
        long lastTime = timestamps[0];
        IDeviceID deviceID = this.tablet.getDeviceID(this.index[0].intValue());
        HashSet<IDeviceID> deviceIDSet = new HashSet<IDeviceID>();
        deviceIDSet.add(deviceID);
        int size = this.tablet.getRowSize();
        for (int i = 1; i < size; ++i) {
            deviceID = this.tablet.getDeviceID(this.index[i].intValue());
            if (lastTime == (lastTime = timestamps[i])) {
                if (deviceIDSet.contains(deviceID)) continue;
                timestamps[this.deduplicatedSize] = lastTime;
                this.index[this.deduplicatedSize++] = this.index[i];
                deviceIDSet.add(deviceID);
                continue;
            }
            timestamps[this.deduplicatedSize] = lastTime;
            this.index[this.deduplicatedSize++] = this.index[i];
            deviceIDSet.clear();
            deviceIDSet.add(deviceID);
        }
    }

    private void sortAndDeduplicateValuesAndBitMapsIgnoreTimestamp() {
        int columnIndex = 0;
        int size = this.tablet.getSchemas().size();
        for (int i = 0; i < size; ++i) {
            IMeasurementSchema schema = (IMeasurementSchema)this.tablet.getSchemas().get(i);
            if (schema == null) continue;
            this.tablet.getValues()[columnIndex] = PipeTabletEventSorter.reorderValueList(this.deduplicatedSize, this.tablet.getValues()[columnIndex], schema.getType(), this.index);
            if (this.tablet.getBitMaps() != null && this.tablet.getBitMaps()[columnIndex] != null) {
                this.tablet.getBitMaps()[columnIndex] = PipeTabletEventSorter.reorderBitMap(this.deduplicatedSize, this.tablet.getBitMaps()[columnIndex], this.index);
            }
            ++columnIndex;
        }
        this.tablet.setRowSize(this.deduplicatedSize);
    }
}

