/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.opcua;

import java.nio.file.Paths;
import java.sql.Date;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.pipe.connector.protocol.opcua.OpcUaServerBuilder;
import org.apache.iotdb.db.pipe.connector.util.sorter.PipeTableModelTabletEventSorter;
import org.apache.iotdb.db.pipe.connector.util.sorter.PipeTreeModelTabletEventSorter;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.tsfile.enums.ColumnCategory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.ManagedNamespaceWithLifecycle;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeServices;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaFolderNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;

public class OpcUaNameSpace
extends ManagedNamespaceWithLifecycle {
    public static final String NAMESPACE_URI = "urn:apache:iotdb:opc-server";
    private final boolean isClientServerModel;
    private final SubscriptionModel subscriptionModel;
    private final OpcUaServerBuilder builder;
    private final String databaseName;
    private final String placeHolder;

    OpcUaNameSpace(OpcUaServer server, boolean isClientServerModel, final OpcUaServerBuilder builder, String qualifiedDatabaseName, String placeHolder) {
        super(server, NAMESPACE_URI);
        this.isClientServerModel = isClientServerModel;
        this.builder = builder;
        this.databaseName = PathUtils.unQualifyDatabaseName((String)qualifiedDatabaseName);
        this.placeHolder = placeHolder;
        this.subscriptionModel = new SubscriptionModel(server, (AttributeServices)this);
        this.getLifecycleManager().addLifecycle((Lifecycle)this.subscriptionModel);
        this.getLifecycleManager().addLifecycle(new Lifecycle(){

            public void startup() {
            }

            public void shutdown() {
                OpcUaNameSpace.this.getServer().shutdown();
                builder.close();
            }
        });
    }

    void transfer(Tablet tablet, boolean isTableModel) throws UaException {
        if (this.isClientServerModel) {
            this.transferTabletForClientServerModel(tablet, isTableModel);
        } else {
            this.transferTabletForPubSubModel(tablet, isTableModel);
        }
    }

    private void transferTabletForClientServerModel(Tablet tablet, boolean isTableModel) {
        List schemas = tablet.getSchemas();
        ArrayList<IMeasurementSchema> newSchemas = new ArrayList<IMeasurementSchema>();
        if (!isTableModel) {
            new PipeTreeModelTabletEventSorter(tablet).deduplicateAndSortTimestampsIfNecessary();
            ArrayList<Long> timestamps = new ArrayList<Long>();
            ArrayList<Object> values = new ArrayList<Object>();
            block0: for (int i = 0; i < schemas.size(); ++i) {
                for (int j = tablet.getRowSize() - 1; j >= 0; --j) {
                    if (tablet.isNull(j, i)) continue;
                    newSchemas.add((IMeasurementSchema)schemas.get(i));
                    timestamps.add(tablet.getTimestamp(j));
                    values.add(OpcUaNameSpace.getTabletObjectValue4Opc(tablet.getValues()[i], j, ((IMeasurementSchema)schemas.get(i)).getType()));
                    continue block0;
                }
            }
            this.transferTabletRowForClientServerModel(tablet.getDeviceId().split("\\."), newSchemas, timestamps, values);
        } else {
            int i;
            new PipeTableModelTabletEventSorter(tablet).sortAndDeduplicateByTimestampIfNecessary();
            ArrayList<Integer> columnIndexes = new ArrayList<Integer>();
            for (i = 0; i < schemas.size(); ++i) {
                if (tablet.getColumnTypes().get(i) != ColumnCategory.FIELD) continue;
                columnIndexes.add(i);
                newSchemas.add((IMeasurementSchema)schemas.get(i));
            }
            for (i = 0; i < tablet.getRowSize(); ++i) {
                Object[] segments = tablet.getDeviceID(i).getSegments();
                String[] folderSegments = new String[segments.length + 1];
                folderSegments[0] = this.databaseName;
                for (int j = 0; j < segments.length; ++j) {
                    folderSegments[j + 1] = Objects.isNull(segments[j]) ? this.placeHolder : (String)segments[j];
                }
                int finalI = i;
                this.transferTabletRowForClientServerModel(folderSegments, newSchemas, Collections.singletonList(tablet.getTimestamp(i)), columnIndexes.stream().map(index -> tablet.isNull(finalI, index.intValue()) ? null : OpcUaNameSpace.getTabletObjectValue4Opc(tablet.getValues()[index], finalI, ((IMeasurementSchema)schemas.get((int)index)).getType())).collect(Collectors.toList()));
            }
        }
    }

    private void transferTabletRowForClientServerModel(String[] segments, List<IMeasurementSchema> measurementSchemas, List<Long> timestamps, List<Object> values) {
        if (segments.length == 0) {
            throw new PipeRuntimeCriticalException("The segments of tablets must exist");
        }
        StringBuilder currentStr = new StringBuilder();
        UaNode folderNode = null;
        for (String segment : segments) {
            currentStr.append(segment);
            NodeId folderNodeId = this.newNodeId(currentStr.toString());
            currentStr.append("/");
            if (!this.getNodeManager().containsNode(folderNodeId)) {
                UaFolderNode nextFolderNode = new UaFolderNode(this.getNodeContext(), folderNodeId, this.newQualifiedName(segment), LocalizedText.english((String)segment));
                this.getNodeManager().addNode((Node)nextFolderNode);
                if (Objects.nonNull(folderNode)) {
                    folderNode.addReference(new Reference(folderNode.getNodeId(), Identifiers.Organizes, nextFolderNode.getNodeId().expanded(), true));
                } else {
                    nextFolderNode.addReference(new Reference(folderNodeId, Identifiers.Organizes, Identifiers.ObjectsFolder.expanded(), false));
                }
                folderNode = nextFolderNode;
                continue;
            }
            folderNode = (UaNode)this.getNodeManager().getNode(folderNodeId).orElseThrow(() -> new PipeRuntimeCriticalException(String.format("The folder node for %s does not exist.", Arrays.toString(segments))));
        }
        String currentFolder = currentStr.toString();
        for (int i = 0; i < measurementSchemas.size(); ++i) {
            UaVariableNode measurementNode;
            if (Objects.isNull(values.get(i))) continue;
            String name = measurementSchemas.get(i).getMeasurementName();
            TSDataType type = measurementSchemas.get(i).getType();
            NodeId nodeId = this.newNodeId(currentFolder + name);
            if (!this.getNodeManager().containsNode(nodeId)) {
                measurementNode = new UaVariableNode.UaVariableNodeBuilder(this.getNodeContext()).setNodeId(this.newNodeId(currentFolder + name)).setAccessLevel((Set)AccessLevel.READ_WRITE).setUserAccessLevel((Set)AccessLevel.READ_ONLY).setBrowseName(this.newQualifiedName(name)).setDisplayName(LocalizedText.english((String)name)).setDataType(this.convertToOpcDataType(type)).setTypeDefinition(Identifiers.BaseDataVariableType).build();
                this.getNodeManager().addNode((Node)measurementNode);
                folderNode.addReference(new Reference(folderNode.getNodeId(), Identifiers.Organizes, measurementNode.getNodeId().expanded(), true));
            } else {
                measurementNode = (UaVariableNode)this.getNodeManager().getNode(nodeId).orElseThrow(() -> new PipeRuntimeCriticalException(String.format("The Node %s does not exist.", nodeId)));
            }
            long utcTimestamp = OpcUaNameSpace.timestampToUtc(timestamps.get(timestamps.size() > 1 ? i : 0));
            if (!Objects.isNull(measurementNode.getValue()) && Objects.requireNonNull(measurementNode.getValue().getSourceTime()).getUtcTime() >= utcTimestamp) continue;
            measurementNode.setValue(new DataValue(new Variant(values.get(i)), StatusCode.GOOD, new DateTime(utcTimestamp), new DateTime()));
        }
    }

    private static Object getTabletObjectValue4Opc(Object column, int rowIndex, TSDataType type) {
        switch (type) {
            case BOOLEAN: {
                return ((boolean[])column)[rowIndex];
            }
            case INT32: {
                return ((int[])column)[rowIndex];
            }
            case DATE: {
                return new DateTime((java.util.Date)Date.valueOf(((LocalDate[])column)[rowIndex]));
            }
            case INT64: {
                return ((long[])column)[rowIndex];
            }
            case TIMESTAMP: {
                return new DateTime(OpcUaNameSpace.timestampToUtc(((long[])column)[rowIndex]));
            }
            case FLOAT: {
                return Float.valueOf(((float[])column)[rowIndex]);
            }
            case DOUBLE: {
                return ((double[])column)[rowIndex];
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                return ((Binary[])column)[rowIndex].toString();
            }
        }
        throw new UnSupportedDataTypeException("UnSupported dataType " + type);
    }

    private static long timestampToUtc(long timeStamp) {
        return TimestampPrecisionUtils.currPrecision.toNanos(timeStamp) / 100L + 116444736000000000L;
    }

    private void transferTabletForPubSubModel(Tablet tablet, boolean isTableModel) throws UaException {
        BaseEventTypeNode eventNode = this.getServer().getEventFactory().createEvent(new NodeId(this.getNamespaceIndex(), UUID.randomUUID()), Identifiers.BaseEventType);
        ArrayList<String> sourceNameList = null;
        if (isTableModel) {
            sourceNameList = new ArrayList<String>(tablet.getRowSize());
            for (int i = 0; i < tablet.getRowSize(); ++i) {
                StringBuilder idBuilder = new StringBuilder(this.databaseName);
                for (Object segment : tablet.getDeviceID(i).getSegments()) {
                    idBuilder.append(".").append(Objects.isNull(segment) ? this.placeHolder : segment);
                }
                sourceNameList.add(idBuilder.toString());
            }
        }
        for (int columnIndex = 0; columnIndex < tablet.getSchemas().size(); ++columnIndex) {
            if (isTableModel && !((ColumnCategory)tablet.getColumnTypes().get(columnIndex)).equals((Object)ColumnCategory.FIELD)) continue;
            TSDataType dataType = ((IMeasurementSchema)tablet.getSchemas().get(columnIndex)).getType();
            if (!isTableModel) {
                eventNode.setSourceName(tablet.getDeviceId() + "." + ((IMeasurementSchema)tablet.getSchemas().get(columnIndex)).getMeasurementName());
            }
            eventNode.setSourceNode(this.convertToOpcDataType(dataType));
            for (int rowIndex = 0; rowIndex < tablet.getRowSize(); ++rowIndex) {
                if (tablet.getBitMaps()[columnIndex].isMarked(rowIndex)) continue;
                if (Objects.nonNull(sourceNameList)) {
                    String deviceId = (String)sourceNameList.get(rowIndex);
                    if (Objects.isNull(deviceId)) continue;
                    eventNode.setSourceName(deviceId + "." + ((IMeasurementSchema)tablet.getSchemas().get(columnIndex)).getMeasurementName());
                }
                eventNode.setTime(new DateTime(OpcUaNameSpace.timestampToUtc(tablet.getTimestamp(rowIndex))));
                switch (dataType) {
                    case BOOLEAN: {
                        eventNode.setMessage(LocalizedText.english((String)Boolean.toString((Boolean)tablet.getValue(rowIndex, columnIndex))));
                        break;
                    }
                    case INT32: {
                        eventNode.setMessage(LocalizedText.english((String)Integer.toString((Integer)tablet.getValue(rowIndex, columnIndex))));
                        break;
                    }
                    case DATE: {
                        eventNode.setMessage(LocalizedText.english((String)((LocalDate)tablet.getValue(rowIndex, columnIndex)).atStartOfDay(ZoneId.systemDefault()).toString()));
                        break;
                    }
                    case INT64: {
                        eventNode.setMessage(LocalizedText.english((String)Long.toString((Long)tablet.getValue(rowIndex, columnIndex))));
                        break;
                    }
                    case TIMESTAMP: {
                        eventNode.setMessage(LocalizedText.english((String)DateTimeUtils.convertLongToDate((Long)tablet.getValue(rowIndex, columnIndex))));
                        break;
                    }
                    case FLOAT: {
                        eventNode.setMessage(LocalizedText.english((String)Float.toString(((Float)tablet.getValue(rowIndex, columnIndex)).floatValue())));
                        break;
                    }
                    case DOUBLE: {
                        eventNode.setMessage(LocalizedText.english((String)Double.toString((Double)tablet.getValue(rowIndex, columnIndex))));
                        break;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        eventNode.setMessage(LocalizedText.english((String)tablet.getValue(rowIndex, columnIndex).toString()));
                        break;
                    }
                    default: {
                        throw new PipeRuntimeNonCriticalException("Unsupported data type: " + ((IMeasurementSchema)tablet.getSchemas().get(columnIndex)).getType());
                    }
                }
                this.getServer().getEventBus().post((Object)eventNode);
            }
        }
        eventNode.delete();
    }

    private NodeId convertToOpcDataType(TSDataType type) {
        switch (type) {
            case BOOLEAN: {
                return Identifiers.Boolean;
            }
            case INT32: {
                return Identifiers.Int32;
            }
            case DATE: 
            case TIMESTAMP: {
                return Identifiers.DateTime;
            }
            case INT64: {
                return Identifiers.Int64;
            }
            case FLOAT: {
                return Identifiers.Float;
            }
            case DOUBLE: {
                return Identifiers.Double;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                return Identifiers.String;
            }
        }
        throw new PipeRuntimeNonCriticalException("Unsupported data type: " + type);
    }

    public void onDataItemsCreated(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsCreated(dataItems);
    }

    public void onDataItemsModified(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsModified(dataItems);
    }

    public void onDataItemsDeleted(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsDeleted(dataItems);
    }

    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        this.subscriptionModel.onMonitoringModeChanged(monitoredItems);
    }

    void checkEquals(String user, String password, String securityDir, boolean enableAnonymousAccess) {
        this.builder.checkEquals(user, password, Paths.get(securityDir, new String[0]), enableAnonymousAccess);
    }
}

