/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeTTLCache;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.SettleCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.ISettleSelector;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ArrayDeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettleSelectorImpl
implements ISettleSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final boolean heavySelect;
    private final String storageGroupName;
    private final String dataRegionId;
    private final long timePartition;
    private final TsFileManager tsFileManager;
    private boolean isSeq;
    private final CompactionScheduleContext context;

    public SettleSelectorImpl(boolean heavySelect, String storageGroupName, String dataRegionId, long timePartition, TsFileManager tsFileManager, CompactionScheduleContext context) {
        this.heavySelect = heavySelect;
        this.storageGroupName = storageGroupName;
        this.dataRegionId = dataRegionId;
        this.timePartition = timePartition;
        this.tsFileManager = tsFileManager;
        this.context = context;
    }

    @Override
    public List<SettleCompactionTask> selectSettleTask(List<TsFileResource> tsFileResources) {
        if (tsFileResources.isEmpty()) {
            return Collections.emptyList();
        }
        this.isSeq = tsFileResources.get(0).isSeq();
        return this.selectTasks(tsFileResources);
    }

    private List<SettleCompactionTask> selectTasks(List<TsFileResource> resources) {
        ArrayList<TsFileResource> fullyDirtyResource = new ArrayList<TsFileResource>();
        ArrayList<PartiallyDirtyResource> partiallyDirtyResourceList = new ArrayList<PartiallyDirtyResource>();
        PartiallyDirtyResource partiallyDirtyResource = new PartiallyDirtyResource();
        try {
            for (TsFileResource resource : resources) {
                boolean shouldStop = false;
                FileDirtyInfo fileDirtyInfo = resource.getStatus() != TsFileResourceStatus.NORMAL ? new FileDirtyInfo(DirtyStatus.NOT_SATISFIED) : (!this.heavySelect ? this.selectFileBaseOnModSize(resource) : this.selectFileBaseOnDirtyData(resource));
                switch (fileDirtyInfo.status) {
                    case FULLY_DIRTY: {
                        fullyDirtyResource.add(resource);
                        break;
                    }
                    case PARTIALLY_DIRTY: {
                        shouldStop = partiallyDirtyResource.add(resource, fileDirtyInfo.dirtyDataSize);
                        break;
                    }
                    case NOT_SATISFIED: {
                        shouldStop = !partiallyDirtyResource.getResources().isEmpty();
                        break;
                    }
                }
                if (!shouldStop) continue;
                partiallyDirtyResourceList.add(partiallyDirtyResource);
                partiallyDirtyResource = new PartiallyDirtyResource();
                if (this.heavySelect) continue;
                break;
            }
            partiallyDirtyResourceList.add(partiallyDirtyResource);
            return this.createTask(fullyDirtyResource, partiallyDirtyResourceList);
        }
        catch (Exception e) {
            LOGGER.error("{}-{} cannot select file for settle compaction", new Object[]{this.storageGroupName, this.dataRegionId, e});
            return Collections.emptyList();
        }
    }

    private FileDirtyInfo selectFileBaseOnModSize(TsFileResource resource) {
        long totalModSize = resource.getTotalModSizeInByte();
        if (totalModSize <= 0L) {
            return new FileDirtyInfo(DirtyStatus.NOT_SATISFIED);
        }
        return totalModSize > config.getInnerCompactionTaskSelectionModsFileThreshold() || !CompactionUtils.isDiskHasSpace(config.getInnerCompactionTaskSelectionDiskRedundancy()) ? new FileDirtyInfo(DirtyStatus.PARTIALLY_DIRTY) : new FileDirtyInfo(DirtyStatus.NOT_SATISFIED);
    }

    private FileDirtyInfo selectFileBaseOnDirtyData(TsFileResource resource) throws IOException {
        Collection<ModEntry> modifications = resource.getAllModEntries();
        ITimeIndex timeIndex = resource.getTimeIndex();
        if (timeIndex instanceof FileTimeIndex) {
            timeIndex = CompactionUtils.buildDeviceTimeIndex(resource);
        }
        HashSet<IDeviceID> deletedDevices = new HashSet<IDeviceID>();
        boolean hasExpiredTooLong = false;
        long currentTime = CommonDateTimeUtils.currentTime();
        for (IDeviceID device : ((ArrayDeviceTimeIndex)timeIndex).getDevices()) {
            boolean isDeleted;
            String tableName = device.getTableName();
            long ttl = tableName.startsWith("root.") ? DataNodeTTLCache.getInstance().getTTLForTree(device) : DataNodeTTLCache.getInstance().getTTLForTable(this.storageGroupName, tableName);
            boolean hasSetTTL = ttl != Long.MAX_VALUE;
            long endTime = timeIndex.getEndTime(device).get();
            boolean bl = isDeleted = !timeIndex.isDeviceAlive(device, ttl) || this.isDeviceDeletedByMods(modifications, device, timeIndex.getStartTime(device).get(), endTime);
            if (hasSetTTL) {
                if (!isDeleted) {
                    return new FileDirtyInfo(DirtyStatus.NOT_SATISFIED);
                }
                if (currentTime > endTime) {
                    long outdatedTimeDiff = currentTime - endTime;
                    if (endTime < 0L && outdatedTimeDiff < currentTime) {
                        outdatedTimeDiff = Long.MAX_VALUE;
                    }
                    long ttlThreshold = 3L * ttl > ttl ? ttl : Long.MAX_VALUE;
                    boolean bl2 = hasExpiredTooLong = hasExpiredTooLong || outdatedTimeDiff > Math.min(config.getMaxExpiredTime(), ttlThreshold);
                }
            }
            if (!isDeleted) continue;
            deletedDevices.add(device);
        }
        double deletedDeviceRatio = (double)deletedDevices.size() / (double)((ArrayDeviceTimeIndex)timeIndex).getDevices().size();
        if (deletedDeviceRatio == 1.0) {
            return new FileDirtyInfo(DirtyStatus.FULLY_DIRTY);
        }
        boolean bl = hasExpiredTooLong = config.getMaxExpiredTime() != Long.MAX_VALUE && hasExpiredTooLong;
        if (hasExpiredTooLong || deletedDeviceRatio >= (double)config.getExpiredDataRatio()) {
            return new FileDirtyInfo(DirtyStatus.PARTIALLY_DIRTY, (long)(deletedDeviceRatio * (double)resource.getTsFileSize()));
        }
        return new FileDirtyInfo(DirtyStatus.NOT_SATISFIED);
    }

    private boolean isDeviceDeletedByMods(Collection<ModEntry> modifications, IDeviceID device, long startTime, long endTime) {
        return ModificationUtils.isAllDeletedByMods(modifications, device, startTime, endTime);
    }

    private List<SettleCompactionTask> createTask(List<TsFileResource> fullyDirtyResources, List<PartiallyDirtyResource> partiallyDirtyResourceList) {
        ArrayList<SettleCompactionTask> tasks = new ArrayList<SettleCompactionTask>();
        for (int i = 0; i < partiallyDirtyResourceList.size(); ++i) {
            if (i == 0) {
                if (fullyDirtyResources.isEmpty() && partiallyDirtyResourceList.get(i).getResources().isEmpty()) continue;
                tasks.add(new SettleCompactionTask(this.timePartition, this.tsFileManager, fullyDirtyResources, partiallyDirtyResourceList.get(i).getResources(), this.isSeq, this.createCompactionPerformer(), this.tsFileManager.getNextCompactionTaskId()));
                continue;
            }
            if (partiallyDirtyResourceList.get(i).getResources().isEmpty()) continue;
            tasks.add(new SettleCompactionTask(this.timePartition, this.tsFileManager, Collections.emptyList(), partiallyDirtyResourceList.get(i).getResources(), this.isSeq, this.createCompactionPerformer(), this.tsFileManager.getNextCompactionTaskId()));
        }
        return tasks;
    }

    private ICompactionPerformer createCompactionPerformer() {
        return this.isSeq ? this.context.getSeqCompactionPerformer() : this.context.getUnseqCompactionPerformer();
    }

    static class PartiallyDirtyResource {
        List<TsFileResource> resources = new ArrayList<TsFileResource>();
        long totalFileSize = 0L;

        PartiallyDirtyResource() {
        }

        public boolean add(TsFileResource resource, long dirtyDataSize) {
            this.resources.add(resource);
            this.totalFileSize += resource.getTsFileSize();
            this.totalFileSize -= dirtyDataSize;
            return this.checkHasReachedThreshold();
        }

        public List<TsFileResource> getResources() {
            return this.resources;
        }

        public boolean checkHasReachedThreshold() {
            return this.resources.size() >= config.getInnerCompactionCandidateFileNum() || this.totalFileSize >= config.getTargetCompactionFileSize();
        }
    }

    static class FileDirtyInfo {
        DirtyStatus status;
        long dirtyDataSize = 0L;

        public FileDirtyInfo(DirtyStatus status) {
            this.status = status;
        }

        public FileDirtyInfo(DirtyStatus status, long dirtyDataSize) {
            this.status = status;
            this.dirtyDataSize = dirtyDataSize;
        }
    }

    static enum DirtyStatus {
        FULLY_DIRTY,
        PARTIALLY_DIRTY,
        NOT_SATISFIED;

    }
}

